/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class EmberlashSwordItem
extends UniqueSwordItem {
    public static float tooltipEffectDamage = 0.2f;

    public EmberlashSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            HelperMethods.playHitSounds(attacker, target);
            if (target.hasEffect(EffectRegistry.getReference(EffectRegistry.SMOULDERING))) {
                target.invulnerableTime = 0;
                MobEffectInstance smoulderingEffect = target.getEffect(EffectRegistry.getReference(EffectRegistry.SMOULDERING));
                if (smoulderingEffect != null) {
                    DamageSource damageSource;
                    if (attacker instanceof Player) {
                        Player player = (Player)attacker;
                        damageSource = player.damageSources().playerAttack(player);
                    } else {
                        damageSource = world.damageSources().generic();
                    }
                    DamageSource damageSource2 = damageSource;
                    float abilityDamage = Math.max(HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.emberlash.spellScaling, (Entity)attacker, "fire"), (float)HelperMethods.getEntityAttackDamage(attacker));
                    float damageMultiplier = 0.15f * (float)smoulderingEffect.getAmplifier();
                    target.hurt(damageSource2, abilityDamage * damageMultiplier);
                    HelperMethods.spawnOrbitParticles(world, target.position(), (ParticleOptions)ParticleTypes.LAVA, 0.2, smoulderingEffect.getAmplifier());
                    world.playSound((Entity)target, target.blockPosition(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), target.getSoundSource(), 0.1f, 1.5f);
                }
            }
            int maximum_stacks = Config.uniqueEffects.emberlash.maxStacks;
            HelperMethods.incrementStatusEffect(target, EffectRegistry.getReference(EffectRegistry.SMOULDERING), 100, 1, maximum_stacks + 1);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.swing(hand);
        world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), user.getSoundSource(), 0.5f, 1.0f);
        user.setDeltaMovement(user.getLookAngle().reverse().scale(1.5));
        user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
        user.hurtMarked = true;
        user.heal(user.getMaxHealth() * Config.uniqueEffects.emberlash.heal / 100.0f);
        user.getCooldowns().addCooldown((Item)this, Config.uniqueEffects.emberlash.cooldown);
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.SMOKE, (ParticleOptions)ParticleTypes.SMOKE, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip5", (Object[])new Object[]{Float.valueOf(tooltipEffectDamage)}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberlashsworditem.tooltip7", (Object[])new Object[]{Float.valueOf(Config.uniqueEffects.emberlash.heal)}).setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f, max=100.0f)
        public float heal;
        @ValidatedInt.Restrict(min=1)
        public int maxStacks;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.EMBERLASH.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 80;
            this.heal = 15.0f;
            this.maxStacks = 5;
            this.spellScaling = 0.4f;
        }
    }
}

