/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import elocindev.necronomicon.api.text.TextAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class DreadtideSwordItem
extends UniqueSwordItem {
    public DreadtideSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide() && world instanceof ServerLevel) {
            MobEffectInstance voidcloakEffect;
            LivingEntity ee;
            ServerLevel serverWorld = (ServerLevel)world;
            int voidcallerDuration = ((EffectSettings)Config.uniqueEffects.dreadtide.get()).duration;
            float voidcallerDamageModifier = ((EffectSettings)Config.uniqueEffects.dreadtide.get()).damageModifier;
            int skillCooldown = 20;
            AABB box = HelperMethods.createBox((Entity)user, 10.0);
            Entity closestEntity = world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)user))).orElse(null);
            if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, (LivingEntity)user) && (voidcloakEffect = user.getEffect(EffectRegistry.getReference(EffectRegistry.VOIDCLOAK))) != null) {
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_04.get();
                ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_04.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_12.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_15.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_20.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                if (sounds.get(voidcloakEffect.getAmplifier()) != null) {
                    soundSelect = (SoundEvent)sounds.get(Math.min(5, voidcloakEffect.getAmplifier()));
                }
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.SMOKE, (Entity)user, (Entity)ee, particleCount);
                world.playSound(null, user.blockPosition(), soundSelect, user.getSoundSource(), 0.3f, 1.3f);
                SimplySwordsStatusEffectInstance voidAssaultEffect = new SimplySwordsStatusEffectInstance(EffectRegistry.getReference(EffectRegistry.VOIDASSAULT), voidcallerDuration, voidcloakEffect.getAmplifier(), false, false, true);
                voidAssaultEffect.setSourceEntity((LivingEntity)user);
                voidAssaultEffect.setAdditionalData((int)(HelperMethods.getEntityAttackDamage((LivingEntity)user) * (double)voidcallerDamageModifier));
                ee.addEffect((MobEffectInstance)voidAssaultEffect);
                user.removeEffect(EffectRegistry.getReference(EffectRegistry.VOIDCLOAK));
                user.getCooldowns().addCooldown((Item)this, skillCooldown);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public Component getName(ItemStack stack) {
        MutableComponent name = Component.translatable((String)stack.getDescriptionId());
        Style bold = name.getStyle().withBold(Boolean.valueOf(true));
        return TextAPI.Styles.getGradient((Component)Component.translatable((String)this.getDescriptionId(stack)).setStyle(bold), (int)1, (int)6043781, (int)12088090, (float)1.0f);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        MutableComponent ability_icon = Component.empty().append("\ua996 ");
        MutableComponent types = TextAPI.Styles.getGradient((Component)Component.translatable((String)"item.eldritch_end.corrupted_item.type"), (int)1, (int)6043781, (int)9326287, (float)1.0f);
        tooltip.add((Component)Component.literal((String)"\ua999 ").append((Component)types.withStyle(types.getStyle().withUnderlined(Boolean.valueOf(true)))));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip1").setStyle(Styles.CORRUPTED_ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)ability_icon.append((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.CORRUPTED_LIGHT)));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip10").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip11").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\ua999 ").append((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip12").setStyle(Styles.CORRUPTED)));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.dreadtidesworditem.tooltip13").setStyle(Styles.CORRUPTED));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageModifier = 1.0f;
        @ValidatedInt.Restrict(min=0)
        public int duration = 250;
        @ValidatedInt.Restrict(min=1)
        public int corruptionFrequency = 60;
        @ValidatedFloat.Restrict(min=0.0f)
        public float corruptionPerTick = 1.0f;
        @ValidatedInt.Restrict(min=0)
        public int corruptionDuration = 1200;
        @ValidatedFloat.Restrict(min=0.0f)
        public float corruptionMax = 100.0f;
        @ValidatedInt.Restrict(min=1)
        public int startingTickFrequency = 12;

        public EffectSettings() {
            super(new ItemStackTooltipAppender(() -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"dreadtide"))));
        }
    }
}

