/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.entity.ThrownSpearEntity;
import net.sweenus.simplyswords.item.SimplySwordsSwordItem;
import net.sweenus.simplyswords.util.HelperMethods;

public class SimplySwordsThrowableItem
extends SimplySwordsSwordItem {
    public SimplySwordsThrowableItem(Tier toolMaterial, Item.Properties settings, String ... repairIngredient) {
        super(toolMaterial, settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            itemStack = user.getItemInHand(hand);
            ThrownSpearEntity thrownSwordEntity = new ThrownSpearEntity(world, (LivingEntity)user, itemStack.copy());
            thrownSwordEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            thrownSwordEntity.setYRot(user.getYRot());
            thrownSwordEntity.setXRot(user.getXRot() - 90.0f);
            double[] doubles = HelperMethods.getAttackFromSlot(user, itemStack, user.getUsedItemHand());
            thrownSwordEntity.primaryBaseDamage = (float)doubles[0];
            thrownSwordEntity.hasLoyalty = Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)((ServerLevel)world), (ItemStack)itemStack, (Entity)user), (int)0, (int)127);
            if (hand == InteractionHand.OFF_HAND) {
                thrownSwordEntity.offhandThrow = true;
            }
            thrownSwordEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)thrownSwordEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        user.getCooldowns().addCooldown((Item)this, 1);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }
}

