/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.client.api.SimplySwordsClientAPI;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.ThrownSpearEntity;
import net.sweenus.simplyswords.power.GemPowerComponent;
import net.sweenus.simplyswords.power.PowerType;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.registry.TagRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class RunicSwordItem
extends SwordItem {
    public RunicSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings.fireResistant());
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (!stack.has((DataComponentType)ComponentTypeRegistry.GEM_POWER.get())) {
            String[] blacklist = new String[]{"simplyswords:gem_power@simplyswords:throwing"};
            if (TagRegistry.isInTag(TagRegistry.spearsTag, this.asItem())) {
                stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNIC, blacklist)));
            } else {
                stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNIC)));
            }
        }
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
            HelperMethods.playHitSounds(attacker, target);
            component.postHit(stack, target, attacker);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
            component.onStoppedUsing(stack, world, user, remainingUseTicks);
        }
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
            component.usageTick(world, user, stack, remainingUseTicks);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
        return component.getMaxUseTime(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"spears"));
        if (itemStack.getItem().builtInRegistryHolder().is(tagKey)) {
            if (!world.isClientSide) {
                itemStack = user.getItemInHand(hand);
                ThrownSpearEntity thrownSwordEntity = new ThrownSpearEntity(world, (LivingEntity)user, itemStack.copy());
                thrownSwordEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
                thrownSwordEntity.setYRot(user.getYRot());
                thrownSwordEntity.setXRot(user.getXRot() - 90.0f);
                double[] doubles = HelperMethods.getAttackFromSlot(user, itemStack, user.getUsedItemHand());
                thrownSwordEntity.primaryBaseDamage = (float)doubles[0];
                thrownSwordEntity.hasLoyalty = Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)((ServerLevel)world), (ItemStack)itemStack, (Entity)user), (int)0, (int)127);
                if (hand == InteractionHand.OFF_HAND) {
                    thrownSwordEntity.offhandThrow = true;
                }
                thrownSwordEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
                world.addFreshEntity((Entity)thrownSwordEntity);
                GemPowerComponent component = SimplySwordsAPI.getComponent(itemStack);
                if (!user.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                return component.use(world, user, hand);
            }
            user.swing(hand);
            user.getCooldowns().addCooldown((Item)this, 1);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        if (itemStack.getDamageValue() < itemStack.getMaxDamage() - 1) {
            GemPowerComponent component = SimplySwordsAPI.getComponent(itemStack);
            return component.use(world, user, hand);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity user;
        if (entity instanceof LivingEntity && ((user = (LivingEntity)entity).getItemBySlot(EquipmentSlot.MAINHAND) == stack || user.getItemBySlot(EquipmentSlot.OFFHAND) == stack)) {
            if (entity.tickCount % 4 == 0 && Config.general.enablePassiveParticles) {
                float randomx = (float)(Math.random() * 6.0);
                float randomz = (float)(Math.random() * 6.0);
                world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, user.getX() + user.getHandHoldingItemAngle((Item)this).x(), user.getY() + user.getHandHoldingItemAngle((Item)this).y() + 1.3, user.getZ() + user.getHandHoldingItemAngle((Item)this).z(), (double)(-3.0f + randomx), 0.0, (double)(-3.0f + randomz));
            }
            if (!world.isClientSide) {
                GemPowerComponent component = SimplySwordsAPI.getComponent(stack);
                component.inventoryTick(stack, world, user, slot, selected);
            }
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    public void onCraftedPostProcess(ItemStack stack, Level world) {
        if (world.isClientSide) {
            return;
        }
        if (!stack.has((DataComponentType)ComponentTypeRegistry.GEM_POWER.get())) {
            String[] blacklist = new String[]{"simplyswords:gem_power@simplyswords:throwing"};
            if (TagRegistry.isInTag(TagRegistry.spearsTag, this.asItem())) {
                stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNIC, blacklist)));
            } else {
                stack.set((DataComponentType)ComponentTypeRegistry.GEM_POWER.get(), (Object)GemPowerComponent.runic(GemPowerRegistry.gemRandomPower(PowerType.RUNIC)));
            }
        }
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.RUNIC);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        this.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type);
    }

    protected void generateDynamicTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        SimplySwordsClientAPI.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type, "simplyswords", "oracle_index:books/simplyswords/weapon-types", "oracle_index:books/simplyswords/unique-weapons", "oracle_index:books/simplyswords/runic-powers", null);
    }
}

