/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.entity.ThrownSwordEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FrostfallEntity
extends ThrownSwordEntity {
    private int remainingDetonations = 5;
    public double detonateRadius = 8.0;
    public float detonateDamage = 11.0f;
    public int duration = 40;
    public int addedChance = 0;

    public FrostfallEntity(EntityType<? extends FrostfallEntity> entityType, Level world) {
        super(entityType, world);
    }

    public FrostfallEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(world, owner, stack);
        this.stack = stack;
    }

    @Override
    protected void doEffects(ServerLevel serverWorld, float baseDamage, Entity entity) {
        int bonusParticles = (int)baseDamage / 2;
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.POOF, 0.5, 3 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.CRIT, 0.5, 5 + bonusParticles);
        HelperMethods.spawnOrbitParticles(serverWorld, this.position(), (ParticleOptions)ParticleTypes.ITEM_SNOWBALL, 0.5, 2 + bonusParticles);
        if (baseDamage > this.primaryBaseDamage) {
            serverWorld.playSound(null, entity, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_02.get(), this.getSoundSource(), 0.3f, 1.2f);
        }
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemsRegistry.FROSTFALL.get());
    }

    @Override
    protected void doOnTick(Entity entity) {
        super.doOnTick(entity);
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.inGround) {
                int detonateDelay = 20;
                int chance = 1;
                ServerLevel world = (ServerLevel)this.level();
                DamageSource damageSource = this.damageSources().trident((Entity)this, entity);
                if (this.remainingDetonations <= 0) {
                    this.returnToPlayer = true;
                }
                if (this.tickCount % detonateDelay == 0 && this.remainingDetonations > 0) {
                    int detonateCount = this.remainingDetonations;
                    AABB box = HelperMethods.createBox((Entity)this, this.detonateRadius - (double)detonateCount);
                    for (Entity otherEntity : world.getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        LivingEntity le;
                        if (!(otherEntity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)otherEntity, livingEntity)) continue;
                        HelperMethods.damageThroughIframes((Entity)le, damageSource, this.detonateDamage - (float)detonateCount);
                        le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.duration, Math.min(3, 6 - detonateCount)), (Entity)livingEntity);
                        if (!(le.distanceTo((Entity)this) > 1.0f)) continue;
                        le.setDeltaMovement((this.getX() - le.getX()) / 8.0, (this.getY() - le.getY()) / 8.0, (this.getZ() - le.getZ()) / 8.0);
                    }
                    for (Entity otherEntity2 : world.getEntities((Entity)this, box, EntitySelector.ENTITY_STILL_ALIVE)) {
                        if (!(otherEntity2 instanceof FrostfallEntity)) continue;
                        chance = Math.min(50, chance + this.addedChance);
                    }
                    world.playSound(null, (Entity)this, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_02.get(), this.getSoundSource(), 0.6f - (float)detonateCount / 10.0f, 0.8f + (float)detonateCount / 10.0f);
                    HelperMethods.spawnOrbitParticles(world, this.position(), (ParticleOptions)ParticleTypes.POOF, 6.0f - (float)detonateCount, 9 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.position(), (ParticleOptions)ParticleTypes.CRIT, 6.0f - (float)detonateCount, 15 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.position(), (ParticleOptions)ParticleTypes.ITEM_SNOWBALL, 6.0f - (float)detonateCount, 10 - detonateCount);
                    HelperMethods.spawnOrbitParticles(world, this.position().add(0.0, 1.0, 0.0), (ParticleOptions)ParticleTypes.WHITE_ASH, 6.0f - (float)detonateCount, 40 - detonateCount);
                    if (this.random.nextInt(100) > chance) {
                        --this.remainingDetonations;
                    }
                }
            }
        }
    }

    @Override
    protected byte getLoyalty() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return 3;
        }
        return 0;
    }
}

