/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.custom.DreadtideSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;

public class VoidAssaultEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public VoidAssaultEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.SMOKE);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            int voidcallerStartingTickFrequency = ((DreadtideSwordItem.EffectSettings)Config.uniqueEffects.dreadtide.get()).startingTickFrequency;
            MobEffectInstance mobEffectInstance = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.VOIDASSAULT));
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.tickCount % Math.max(1, voidcallerStartingTickFrequency - amplifier * 2) == 0 && this.additionalData != 0) {
                DamageSource damageSource = livingEntity.damageSources().magic();
                livingEntity.invulnerableTime = 0;
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.damageSources().indirectMagic((Entity)livingEntity, (Entity)this.sourceEntity);
                }
                livingEntity.hurt(damageSource, (float)(this.additionalData + amplifier));
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return super.shouldApplyEffectTickThisTick(pDuration, pAmplifier);
    }
}

