/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class PainEffect
extends MobEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public PainEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            int startingTickFrequency = 15;
            MobEffectInstance mobEffectInstance = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.PAIN));
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.tickCount % Math.max(1, startingTickFrequency - amplifier / 8) == 0) {
                LivingEntity livingEntity2;
                DamageSource damageSource = livingEntity.damageSources().generic();
                float amount = (float)(1 + amplifier) * 0.5f;
                livingEntity.invulnerableTime = 0;
                if (this.sourceEntity != null && (livingEntity2 = this.sourceEntity) instanceof Player) {
                    Player player = (Player)livingEntity2;
                    damageSource = livingEntity.damageSources().playerAttack(player);
                }
                HelperMethods.applyDamageWithoutKnockback(livingEntity, damageSource, amount);
                livingEntity.invulnerableTime = 0;
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

