/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.similarities;

import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.similarities.AfterEffect;
import guideme.internal.shaded.lucene.search.similarities.BasicModel;
import guideme.internal.shaded.lucene.search.similarities.BasicStats;
import guideme.internal.shaded.lucene.search.similarities.Normalization;
import guideme.internal.shaded.lucene.search.similarities.SimilarityBase;
import java.util.ArrayList;
import java.util.List;

public class DFRSimilarity
extends SimilarityBase {
    protected final BasicModel basicModel;
    protected final AfterEffect afterEffect;
    protected final Normalization normalization;

    public DFRSimilarity(BasicModel basicModel, AfterEffect afterEffect, Normalization normalization) {
        this(basicModel, afterEffect, normalization, true);
    }

    public DFRSimilarity(BasicModel basicModel, AfterEffect afterEffect, Normalization normalization, boolean discountOverlaps) {
        super(discountOverlaps);
        if (basicModel == null || afterEffect == null || normalization == null) {
            throw new NullPointerException("null parameters not allowed.");
        }
        this.basicModel = basicModel;
        this.afterEffect = afterEffect;
        this.normalization = normalization;
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        double tfn = this.normalization.tfn(stats, freq, docLen);
        double aeTimes1pTfn = this.afterEffect.scoreTimes1pTfn(stats);
        return stats.getBoost() * this.basicModel.score(stats, tfn, aeTimes1pTfn);
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "boost, query boost", new Explanation[0]));
        }
        Explanation normExpl = this.normalization.explain(stats, freq, docLen);
        double tfn = this.normalization.tfn(stats, freq, docLen);
        double aeTimes1pTfn = this.afterEffect.scoreTimes1pTfn(stats);
        subs.add(normExpl);
        subs.add(this.basicModel.explain(stats, tfn, aeTimes1pTfn));
        subs.add(this.afterEffect.explain(stats, tfn));
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, freq.getValue().doubleValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + String.valueOf(freq.getValue()) + "), computed as boost * basicModel.score(stats, tfn) * afterEffect.score(stats, tfn) from:", subs);
    }

    @Override
    public String toString() {
        return "DFR " + this.basicModel.toString() + this.afterEffect.toString() + this.normalization.toString();
    }

    public BasicModel getBasicModel() {
        return this.basicModel;
    }

    public AfterEffect getAfterEffect() {
        return this.afterEffect;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }
}

