/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.DisjunctionMaxBulkScorer;
import guideme.internal.shaded.lucene.search.DisjunctionMaxScorer;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Matches;
import guideme.internal.shaded.lucene.search.MatchesUtils;
import guideme.internal.shaded.lucene.search.Multiset;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private final Multiset<Query> disjuncts = new Multiset();
    private final List<Query> orderedQueries;
    private final float tieBreakerMultiplier;

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        Objects.requireNonNull(disjuncts, "Collection of Querys must not be null");
        if (tieBreakerMultiplier < 0.0f || tieBreakerMultiplier > 1.0f) {
            throw new IllegalArgumentException("tieBreakerMultiplier must be in [0, 1]");
        }
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.disjuncts.addAll(disjuncts);
        this.orderedQueries = new ArrayList<Query>(disjuncts);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.getDisjuncts().iterator();
    }

    public Collection<Query> getDisjuncts() {
        return Collections.unmodifiableCollection(this.disjuncts);
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new DisjunctionMaxWeight(searcher, scoreMode, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.disjuncts.isEmpty()) {
            return new MatchNoDocsQuery("empty DisjunctionMaxQuery");
        }
        if (this.disjuncts.size() == 1) {
            return this.disjuncts.iterator().next();
        }
        if (this.tieBreakerMultiplier == 1.0f) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Query sub : this.disjuncts) {
                builder.add(sub, BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        boolean actuallyRewritten = false;
        ArrayList<Query> rewrittenDisjuncts = new ArrayList<Query>();
        for (Query sub : this.disjuncts) {
            Query rewrittenSub = sub.rewrite(indexSearcher);
            actuallyRewritten |= rewrittenSub != sub;
            rewrittenDisjuncts.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new DisjunctionMaxQuery(rewrittenDisjuncts, this.tieBreakerMultiplier);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        for (Query q : this.disjuncts) {
            q.visit(v);
        }
    }

    @Override
    public String toString(String field) {
        return this.orderedQueries.stream().map(subquery -> {
            if (subquery instanceof BooleanQuery) {
                return "(" + subquery.toString(field) + ")";
            }
            return subquery.toString(field);
        }).collect(Collectors.joining(" | ", "(", ")" + (String)(this.tieBreakerMultiplier != 0.0f ? "~" + this.tieBreakerMultiplier : "")));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DisjunctionMaxQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DisjunctionMaxQuery other) {
        return this.tieBreakerMultiplier == other.tieBreakerMultiplier && Objects.equals(this.disjuncts, other.disjuncts);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Float.floatToIntBits(this.tieBreakerMultiplier);
        h = 31 * h + Objects.hashCode(this.disjuncts);
        return h;
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected final ArrayList<Weight> weights;
        private final ScoreMode scoreMode;

        public DisjunctionMaxWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(searcher.createWeight(disjunctQuery, scoreMode, boost));
            }
            this.scoreMode = scoreMode;
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            ArrayList<Matches> mis = new ArrayList<Matches>();
            for (Weight weight : this.weights) {
                Matches mi = weight.matches(context, doc);
                if (mi == null) continue;
                mis.add(mi);
            }
            return MatchesUtils.fromSubMatches(mis);
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final ArrayList<ScorerSupplier> scorerSuppliers = new ArrayList<ScorerSupplier>();
            for (Weight w : this.weights) {
                ScorerSupplier ss = w.scorerSupplier(context);
                if (ss == null) continue;
                scorerSuppliers.add(ss);
            }
            if (scorerSuppliers.isEmpty()) {
                return null;
            }
            if (scorerSuppliers.size() == 1) {
                return (ScorerSupplier)scorerSuppliers.get(0);
            }
            return new ScorerSupplier(){
                private long cost = -1L;

                @Override
                public Scorer get(long leadCost) throws IOException {
                    ArrayList<Scorer> scorers = new ArrayList<Scorer>();
                    for (ScorerSupplier ss : scorerSuppliers) {
                        scorers.add(ss.get(leadCost));
                    }
                    return new DisjunctionMaxScorer(DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers, DisjunctionMaxWeight.this.scoreMode);
                }

                @Override
                public BulkScorer bulkScorer() throws IOException {
                    if (DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f && DisjunctionMaxWeight.this.scoreMode == ScoreMode.TOP_SCORES) {
                        ArrayList<BulkScorer> scorers = new ArrayList<BulkScorer>();
                        for (ScorerSupplier ss : scorerSuppliers) {
                            scorers.add(ss.bulkScorer());
                        }
                        return new DisjunctionMaxBulkScorer(scorers);
                    }
                    return super.bulkScorer();
                }

                @Override
                public long cost() {
                    if (this.cost == -1L) {
                        long cost = 0L;
                        for (ScorerSupplier ss : scorerSuppliers) {
                            cost += ss.cost();
                        }
                        this.cost = cost;
                    }
                    return this.cost;
                }

                @Override
                public void setTopLevelScoringClause() throws IOException {
                    if (DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f) {
                        for (ScorerSupplier ss : scorerSuppliers) {
                            ss.setTopLevelScoringClause();
                        }
                    }
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            if (this.weights.size() > 16) {
                return false;
            }
            for (Weight w : this.weights) {
                if (w.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean match = false;
            double max = 0.0;
            double otherSum = 0.0;
            ArrayList<Explanation> subsOnMatch = new ArrayList<Explanation>();
            ArrayList<Explanation> subsOnNoMatch = new ArrayList<Explanation>();
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(context, doc);
                if (e.isMatch()) {
                    match = true;
                    subsOnMatch.add(e);
                    double score = e.getValue().doubleValue();
                    if (score >= max) {
                        otherSum += max;
                        max = score;
                        continue;
                    }
                    otherSum += score;
                    continue;
                }
                if (match) continue;
                subsOnNoMatch.add(e);
            }
            if (match) {
                float score = (float)(max + otherSum * (double)DisjunctionMaxQuery.this.tieBreakerMultiplier);
                String desc = DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:";
                return Explanation.match((Number)Float.valueOf(score), desc, subsOnMatch);
            }
            return Explanation.noMatch("No matching clause", subsOnNoMatch);
        }
    }
}

