/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldsave.mixin;

import com.fastasyncworldsave.FastAsyncWorldSave;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DimensionDataStorage.class})
public abstract class DimensionDataStorageMixin {
    @Shadow
    @Final
    private HolderLookup.Provider registries;

    @Shadow
    protected abstract File getDataFile(String var1);

    @ModifyVariable(method={"getDataFile"}, at=@At(value="HEAD"), argsOnly=true)
    private String fixName(String value) {
        String os = System.getProperty("os.name").toLowerCase();
        if (value.contains(":") && (os.contains("win") || os.contains("mac"))) {
            return value.replace(":", "_");
        }
        return value;
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V"))
    private void fastasyncworldsave$saveOffthread(Map<String, SavedData> instance, BiConsumer<String, SavedData> entry) {
        HashMap<String, CompoundTag> toSave = null;
        for (Map.Entry<String, SavedData> mapEntry : instance.entrySet()) {
            CompoundTag compound;
            String id = mapEntry.getKey();
            SavedData savedData = mapEntry.getValue();
            if (savedData == null || !savedData.isDirty()) continue;
            try {
                compound = savedData.save(new CompoundTag(), this.registries);
            }
            catch (Exception e) {
                FastAsyncWorldSave.LOGGER.error("Level data failed to save for: " + id + " report to the respective mod", (Throwable)e);
                continue;
            }
            if (compound == null) continue;
            if (toSave == null) {
                toSave = new HashMap<String, CompoundTag>();
            }
            savedData.setDirty(false);
            toSave.put(id, compound);
        }
        if (toSave != null) {
            HashMap<String, CompoundTag> saveData = toSave;
            FastAsyncWorldSave.threadPool.submit(() -> {
                for (Map.Entry toSaveEntry : saveData.entrySet()) {
                    try {
                        CompoundTag compoundtag = new CompoundTag();
                        compoundtag.put("data", (Tag)toSaveEntry.getValue());
                        NbtUtils.addCurrentDataVersion((CompoundTag)compoundtag);
                        File file = this.getDataFile((String)toSaveEntry.getKey());
                        File temp = file.toPath().getParent().resolve("tmp_" + file.getName()).toFile();
                        temp.getParentFile().mkdirs();
                        NbtIo.writeCompressed((CompoundTag)compoundtag, (Path)temp.toPath());
                        try {
                            Files.move(temp.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (Exception e) {
                            Files.move(temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (Exception e) {
                        FastAsyncWorldSave.LOGGER.error("Could not save data " + ((CompoundTag)toSaveEntry.getValue()).toString(), (Throwable)e);
                    }
                }
            });
        }
    }
}

