/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.mojang.blaze3d.vertex.PoseStack;
import glitchcore.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.init.ModConfig;

public class TemperatureHooksClient {
    private static final ResourceLocation OVERHEATED_HEART_FULL = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_full");
    private static final ResourceLocation OVERHEATED_HEART_FULL_BLINKING = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_full_blinking");
    private static final ResourceLocation OVERHEATED_HEART_HALF = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_half");
    private static final ResourceLocation OVERHEATED_HEART_HALF_BLINKING = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_half_blinking");
    private static final ResourceLocation OVERHEATED_HEART_HARDCORE_FULL = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_hardcore_full");
    private static final ResourceLocation OVERHEATED_HEART_HARDCORE_FULL_BLINKING = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_hardcore_full_blinking");
    private static final ResourceLocation OVERHEATED_HEART_HARDCORE_HALF = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_hardcore_half");
    private static final ResourceLocation OVERHEATED_HEART_HARDCORE_HALF_BLINKING = ResourceLocation.parse((String)"toughasnails:hud/heart/overheated_hardcore_half_blinking");

    public static void heartBlit(GuiGraphics gui, Gui.HeartType heartType, int x, int y, boolean isHardcore, boolean isBlinking, boolean isHalf) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (heartType == Gui.HeartType.NORMAL && TemperatureHelper.isFullyHyperthermic((Player)player)) {
            gui.blitSprite(TemperatureHooksClient.getOverheatedHeartSprite(isHardcore, isHalf, isBlinking), x, y, 9, 9);
        } else {
            gui.blitSprite(heartType.getSprite(isHardcore, isHalf, isBlinking), x, y, 9, 9);
        }
    }

    public static void adjustSelectedItemText(GuiGraphics guiGraphics) {
        PoseStack pose = guiGraphics.pose();
        if (ModConfig.temperature.enableTemperature && GuiUtils.shouldDrawSurvivalElements()) {
            pose.translate(0.0f, -2.0f, 0.0f);
        }
    }

    private static ResourceLocation getOverheatedHeartSprite(boolean isHardcore, boolean isHalf, boolean isBlinking) {
        if (!isHardcore) {
            if (isHalf) {
                return isBlinking ? OVERHEATED_HEART_HALF_BLINKING : OVERHEATED_HEART_HALF;
            }
            return isBlinking ? OVERHEATED_HEART_FULL_BLINKING : OVERHEATED_HEART_FULL;
        }
        if (isHalf) {
            return isBlinking ? OVERHEATED_HEART_HARDCORE_HALF_BLINKING : OVERHEATED_HEART_HARDCORE_HALF;
        }
        return isBlinking ? OVERHEATED_HEART_HARDCORE_FULL_BLINKING : OVERHEATED_HEART_HARDCORE_FULL;
    }
}

