/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;

public class AreaFill {
    public static void fill(Level level, BlockPos pos, PositionChecker checker) {
        AreaFill.fill(level, pos, checker, ModConfig.temperature.nearHeatCoolProximity);
    }

    public static void fill(Level level, BlockPos pos, PositionChecker checker, int maxDepth) {
        HashSet checked = Sets.newHashSet();
        LinkedList<FillPos> queue = new LinkedList<FillPos>();
        queue.add(new FillPos(pos, 1, Direction.DOWN));
        while (!queue.isEmpty()) {
            FillPos posToCheck = (FillPos)queue.poll();
            if (checked.contains(posToCheck)) continue;
            if (AreaFill.checkPassable(checker, level, posToCheck)) {
                FillPos westPos = posToCheck;
                while (westPos.depth() < maxDepth && AreaFill.checkPassable(checker, level, westPos)) {
                    checked.add(westPos);
                    AreaFill.expand(queue, checked, checker, level, westPos);
                    westPos = westPos.west();
                }
                checked.add(westPos);
                if (!AreaFill.checkPassable(checker, level, westPos)) {
                    AreaFill.checkSolid(checked, checker, level, westPos);
                }
                if (posToCheck.depth() >= maxDepth) continue;
                FillPos eastPos = posToCheck.east();
                while (eastPos.depth() < maxDepth && AreaFill.checkPassable(checker, level, eastPos)) {
                    checked.add(eastPos);
                    AreaFill.expand(queue, checked, checker, level, eastPos);
                    eastPos = eastPos.east();
                }
                checked.add(eastPos);
                if (AreaFill.checkPassable(checker, level, eastPos)) continue;
                AreaFill.checkSolid(checked, checker, level, eastPos);
                continue;
            }
            AreaFill.checkSolid(checked, checker, level, posToCheck);
        }
    }

    private static void expand(Queue<FillPos> queue, Set<FillPos> checked, PositionChecker checker, Level level, FillPos pos) {
        FillPos north = pos.north();
        FillPos south = pos.south();
        FillPos down = pos.below();
        FillPos up = pos.above();
        if (AreaFill.checkPassable(checker, level, north)) {
            queue.add(north);
        } else {
            AreaFill.checkSolid(checked, checker, level, north);
        }
        if (AreaFill.checkPassable(checker, level, south)) {
            queue.add(south);
        } else {
            AreaFill.checkSolid(checked, checker, level, south);
        }
        if (AreaFill.checkPassable(checker, level, down)) {
            queue.add(down);
        } else {
            AreaFill.checkSolid(checked, checker, level, down);
        }
        if (AreaFill.checkPassable(checker, level, up)) {
            queue.add(up);
        } else {
            AreaFill.checkSolid(checked, checker, level, up);
        }
    }

    private static void checkSolid(Set<FillPos> checked, PositionChecker checker, Level level, FillPos pos) {
        checked.add(pos);
        checker.onSolid(level, pos);
    }

    private static boolean checkPassable(PositionChecker checker, Level level, FillPos pos) {
        boolean passable = checker.isPassable(level, pos);
        if (passable) {
            checker.onPassable(level, pos);
        }
        return passable;
    }

    public static interface PositionChecker {
        public void onSolid(Level var1, FillPos var2);

        default public void onPassable(Level level, FillPos pos) {
        }

        default public boolean isPassable(Level level, FillPos pos) {
            BlockState state = level.getBlockState(pos.pos());
            return state.isAir() || state.is(ModTags.Blocks.PASSABLE_BLOCKS) || !this.isFlowBlocking(level, pos, state) && !TemperatureHelper.isHeatingBlock(state) && !TemperatureHelper.isCoolingBlock(state);
        }

        default public boolean isConfined(Level level, BlockPos pos) {
            return pos.getY() < level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).below().getY();
        }

        default public boolean isFlowBlocking(Level level, FillPos pos, BlockState state) {
            return state.isFaceSturdy((BlockGetter)level, pos.pos(), pos.source()) || state.isFaceSturdy((BlockGetter)level, pos.pos(), pos.source().getOpposite());
        }
    }

    public record FillPos(BlockPos pos, int depth, Direction source) {
        public FillPos north() {
            return new FillPos(this.pos().north(), this.depth() + 1, Direction.SOUTH);
        }

        public FillPos south() {
            return new FillPos(this.pos().south(), this.depth() + 1, Direction.NORTH);
        }

        public FillPos east() {
            return new FillPos(this.pos().east(), this.depth() + 1, Direction.WEST);
        }

        public FillPos west() {
            return new FillPos(this.pos().west(), this.depth() + 1, Direction.EAST);
        }

        public FillPos above() {
            return new FillPos(this.pos().above(), this.depth() + 1, Direction.DOWN);
        }

        public FillPos below() {
            return new FillPos(this.pos().below(), this.depth() + 1, Direction.UP);
        }
    }
}

