/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import glitchcore.event.client.RegisterColorsEvent;
import glitchcore.event.client.RegisterParticleSpritesEvent;
import glitchcore.util.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.api.particle.TANParticles;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.client.particle.ThermoregulatorParticle;
import toughasnails.temperature.TemperatureHelperImpl;

public class ModClient {
    static void registerItemProperties() {
        ItemProperties.register((Item)TANItems.THERMOMETER, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"temperature"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            final Map<Integer, Delta> deltas = new HashMap<Integer, Delta>();

            public float unclampedCall(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                LivingEntity holder;
                Object object = holder = entity != null ? entity : stack.getEntityRepresentation();
                if (holder == null) {
                    return 0.5f;
                }
                if (level == null && holder.level() instanceof ClientLevel) {
                    level = (ClientLevel)holder.level();
                }
                if (level == null) {
                    return 0.5f;
                }
                Delta delta = this.deltas.computeIfAbsent(holder.getId(), k -> new Delta());
                delta.update(level, 1.getTemperatureForThermometer((Level)level, (Entity)holder));
                return delta.getValue();
            }

            private static TemperatureLevel getTemperatureForThermometer(Level level, Entity holder) {
                TemperatureLevel temperatureLevel = TemperatureHelper.getTemperatureAtPos(level, holder.blockPosition());
                LocalPlayer player = Minecraft.getInstance().player;
                Set<BlockPos> nearbyThermoregulators = TemperatureHelper.getTemperatureData((Player)player).getNearbyThermoregulators();
                return TemperatureHelperImpl.modifyTemperatureByThermoregulators(level, nearbyThermoregulators, holder.blockPosition(), temperatureLevel);
            }

            private static class Delta {
                private long lastUpdateTick;
                private double currentValue;
                private double rota;

                private Delta() {
                }

                private void update(ClientLevel level, TemperatureLevel temperatureLevel) {
                    if (level.getGameTime() == this.lastUpdateTick) {
                        return;
                    }
                    this.lastUpdateTick = level.getGameTime();
                    double targetValue = (double)temperatureLevel.ordinal() * 0.25;
                    double delta = targetValue - this.currentValue;
                    this.rota += delta * 0.1;
                    this.rota *= 0.87;
                    this.currentValue = Mth.clamp((double)(this.currentValue + this.rota), (double)0.0, (double)1.0);
                }

                public float getValue() {
                    return (float)((double)Math.round(this.currentValue * 20.0) / 20.0);
                }
            }
        });
    }

    public static void registerItemColors(RegisterColorsEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)0xFFFFFF), (Object[])new ItemLike[]{TANItems.WOOL_HELMET, TANItems.WOOL_CHESTPLATE, TANItems.WOOL_LEGGINGS, TANItems.WOOL_BOOTS});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)FoliageColor.getDefaultColor()), (Object[])new ItemLike[]{TANItems.LEAF_HELMET, TANItems.LEAF_CHESTPLATE, TANItems.LEAF_LEGGINGS, TANItems.LEAF_BOOTS});
    }

    public static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> 4709119, (Object[])new Block[]{TANBlocks.RAIN_COLLECTOR});
        event.register((state, world, pos, tintIndex) -> 4159204, (Object[])new Block[]{TANBlocks.WATER_PURIFIER});
    }

    public static void registerParticleSprites(RegisterParticleSpritesEvent event) {
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_COOL, ThermoregulatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_WARM, ThermoregulatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TANParticles.THERMOREGULATOR_NEUTRAL, ThermoregulatorParticle.Provider::new);
    }

    public static void setupRenderTypes() {
        RenderType transparentRenderType = RenderType.cutoutMipped();
        RenderType cutoutRenderType = RenderType.cutout();
        RenderType translucentRenderType = RenderType.translucent();
        RenderHelper.setRenderType((Block)TANBlocks.RAIN_COLLECTOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)TANBlocks.WATER_PURIFIER, (RenderType)cutoutRenderType);
    }
}

