/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import toughasnails.api.block.TANBlocks;
import toughasnails.block.RainCollectorBlock;
import toughasnails.block.TemperatureGaugeBlock;
import toughasnails.block.ThermoregulatorBlock;
import toughasnails.block.WaterPurifierBlock;

public class ModBlocks {
    public static void registerBlocks(BiConsumer<ResourceLocation, Block> func) {
        TANBlocks.THERMOREGULATOR = ModBlocks.register(func, "thermoregulator", (Block)new ThermoregulatorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(ThermoregulatorBlock.lightLevel(6))));
        TANBlocks.TEMPERATURE_GAUGE = ModBlocks.register(func, "temperature_gauge", (Block)new TemperatureGaugeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(1.0f)));
        TANBlocks.RAIN_COLLECTOR = ModBlocks.register(func, "rain_collector", new RainCollectorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).noOcclusion()));
        TANBlocks.WATER_PURIFIER = ModBlocks.register(func, "water_purifier", (Block)new WaterPurifierBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).requiresCorrectToolForDrops().strength(2.5f).sound(SoundType.WOOD).noOcclusion()));
    }

    private static Block register(BiConsumer<ResourceLocation, Block> func, String name, Block block) {
        func.accept(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name), block);
        return block;
    }
}

