/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.mojang.datafixers.DSL;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.block.entity.TemperatureGaugeBlockEntity;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.block.entity.WaterPurifierBlockEntity;

public class ModBlockEntities {
    public static void registerBlockEntities(BiConsumer<ResourceLocation, BlockEntityType<?>> func) {
        TANBlockEntityTypes.WATER_PURIFIER = ModBlockEntities.register(func, "water_purifier", BlockEntityType.Builder.of(WaterPurifierBlockEntity::new, (Block[])new Block[]{TANBlocks.WATER_PURIFIER}));
        TANBlockEntityTypes.TEMPERATURE_GAUGE = ModBlockEntities.register(func, "temperature_gauge", BlockEntityType.Builder.of(TemperatureGaugeBlockEntity::new, (Block[])new Block[]{TANBlocks.TEMPERATURE_GAUGE}));
        TANBlockEntityTypes.THERMOREGULATOR = ModBlockEntities.register(func, "thermoregulator", BlockEntityType.Builder.of(ThermoregulatorBlockEntity::new, (Block[])new Block[]{TANBlocks.THERMOREGULATOR}));
    }

    private static <T extends BlockEntity> BlockEntityType<?> register(BiConsumer<ResourceLocation, BlockEntityType<?>> func, String name, BlockEntityType.Builder<T> builder) {
        BlockEntityType type = builder.build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)name));
        func.accept(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name), type);
        return type;
    }
}

