/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import toughasnails.api.container.TANContainerTypes;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.block.entity.WaterPurifierBlockEntity;
import toughasnails.container.WaterPurifierFilterSlot;
import toughasnails.container.WaterPurifierResultSlot;

public class WaterPurifierContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final Level level;

    public WaterPurifierContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public WaterPurifierContainer(int id, Inventory playerInventory, Container container, ContainerData data) {
        super(TANContainerTypes.WATER_PURIFIER, id);
        this.container = container;
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(container, 0, 56, 17));
        this.addSlot(new WaterPurifierFilterSlot(this, container, 1, 56, 53));
        this.addSlot(new WaterPurifierResultSlot(container, 2, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)playerInventory, slot, 8 + slot * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack prevItem = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            prevItem = slotItem.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(slotItem, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItem, prevItem);
            } else if (index != 1 && index != 0 ? (this.canPurify(slotItem) ? !this.moveItemStackTo(slotItem, 0, 1, false) : (this.isFilter(slotItem) ? !this.moveItemStackTo(slotItem, 1, 2, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(slotItem, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(slotItem, 3, 30, false)))) : !this.moveItemStackTo(slotItem, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == prevItem.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return prevItem;
    }

    protected boolean canPurify(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor(TANRecipeTypes.WATER_PURIFYING, (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    protected boolean isFilter(ItemStack stack) {
        return WaterPurifierBlockEntity.isFilter(stack);
    }

    public int getPurifyProgress() {
        int progress = this.data.get(2);
        int totalTime = this.data.get(3);
        return totalTime != 0 && progress != 0 ? progress * 24 / totalTime : 0;
    }

    public int getFilterProgress() {
        int filterDuration = this.data.get(1);
        if (filterDuration == 0) {
            filterDuration = 200;
        }
        return this.data.get(0) * 13 / filterDuration;
    }

    public boolean isFiltering() {
        return this.data.get(0) > 0;
    }
}

