/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.block.ThermoregulatorBlock;
import toughasnails.container.ThermoregulatorContainer;
import toughasnails.init.ModTags;
import toughasnails.temperature.AreaFill;

public class ThermoregulatorBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int INFORM_PLAYER_RADIUS = 20;
    private static final int SPREAD_RADIUS = 16;
    public static final int CONSUMABLE_DURATION = 1600;
    public static final int SLOT_COOLING = 0;
    public static final int SLOT_HEATING = 1;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int coolingTimeRemaining;
    private int heatingTimeRemaining;
    private int fillTimer = 0;
    private Set<BlockPos> filledBlocks = new HashSet<BlockPos>();
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return ThermoregulatorBlockEntity.this.coolingTimeRemaining;
                }
                case 1: {
                    return ThermoregulatorBlockEntity.this.heatingTimeRemaining;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ThermoregulatorBlockEntity.this.coolingTimeRemaining = value;
                    break;
                }
                case 1: {
                    ThermoregulatorBlockEntity.this.heatingTimeRemaining = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public ThermoregulatorBlockEntity(BlockPos pos, BlockState state) {
        super(TANBlockEntityTypes.THERMOREGULATOR, pos, state);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)lookup);
        this.coolingTimeRemaining = nbt.getInt("CoolingTimeRemaining");
        this.heatingTimeRemaining = nbt.getInt("HeatingTimeRemaining");
        this.fillTimer = nbt.getInt("FillTimer");
        ListTag list = nbt.getList("FilledBlocks", 10);
        this.filledBlocks = new HashSet<BlockPos>();
        for (int i = 0; i < list.size(); ++i) {
            int[] arr = list.getIntArray(i);
            if (arr.length != 3) continue;
            this.filledBlocks.add(new BlockPos(arr[0], arr[1], arr[2]));
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.saveAdditional(nbt, lookup);
        nbt.putInt("CoolingTimeRemaining", this.coolingTimeRemaining);
        nbt.putInt("HeatingTimeRemaining", this.heatingTimeRemaining);
        nbt.putInt("FillTimer", this.fillTimer);
        ListTag list = new ListTag();
        this.filledBlocks.stream().map(NbtUtils::writeBlockPos).forEach(arg_0 -> list.add(arg_0));
        nbt.put("FilledBlocks", (Tag)list);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)lookup);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookup) {
        return this.saveCustomOnly(lookup);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, final ThermoregulatorBlockEntity blockEntity) {
        Item remainingItem;
        Item fuelItem;
        Object fuel;
        boolean previouslyCooling = blockEntity.isCooling();
        boolean previouslyHeating = blockEntity.isHeating();
        boolean changed = false;
        if (!((Boolean)state.getValue((Property)ThermoregulatorBlock.ENABLED)).booleanValue()) {
            blockEntity.filledBlocks.clear();
            if (((Boolean)state.getValue((Property)ThermoregulatorBlock.COOLING)).booleanValue() || ((Boolean)state.getValue((Property)ThermoregulatorBlock.HEATING)).booleanValue()) {
                state = (BlockState)((BlockState)state.setValue((Property)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(false))).setValue((Property)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 3);
                ThermoregulatorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
            return;
        }
        if (blockEntity.isCooling()) {
            --blockEntity.coolingTimeRemaining;
        }
        if (blockEntity.isHeating()) {
            --blockEntity.heatingTimeRemaining;
        }
        if (!blockEntity.isCooling() && !(fuel = (ItemStack)blockEntity.items.get(0)).isEmpty()) {
            fuelItem = fuel.getItem();
            blockEntity.coolingTimeRemaining = 1600;
            changed = true;
            fuel.shrink(1);
            if (fuel.isEmpty()) {
                remainingItem = fuelItem.getCraftingRemainingItem();
                blockEntity.items.set(0, (Object)(remainingItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainingItem)));
            }
        }
        if (!blockEntity.isHeating() && !(fuel = (ItemStack)blockEntity.items.get(1)).isEmpty()) {
            fuelItem = fuel.getItem();
            blockEntity.heatingTimeRemaining = 1600;
            changed = true;
            fuel.shrink(1);
            if (fuel.isEmpty()) {
                remainingItem = fuelItem.getCraftingRemainingItem();
                blockEntity.items.set(1, (Object)(remainingItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainingItem)));
            }
        }
        if (((Boolean)state.getValue((Property)ThermoregulatorBlock.COOLING)).booleanValue() != blockEntity.isCooling()) {
            changed = true;
            state = (BlockState)state.setValue((Property)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(blockEntity.isCooling()));
            level.setBlock(pos, state, 3);
        }
        if (((Boolean)state.getValue((Property)ThermoregulatorBlock.HEATING)).booleanValue() != blockEntity.isHeating()) {
            changed = true;
            state = (BlockState)state.setValue((Property)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(blockEntity.isHeating()));
            level.setBlock(pos, state, 3);
        }
        if (!blockEntity.isHeating() && !blockEntity.isCooling()) {
            blockEntity.filledBlocks.clear();
        }
        if ((blockEntity.isCooling() || blockEntity.isHeating()) && blockEntity.fillTimer % 20 == 0) {
            for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX(), (double)(pos.getY() - 4), (double)pos.getZ()).inflate(20.0, 10.0, 20.0))) {
                ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
                temperature.getNearbyThermoregulators().add(pos);
            }
            BlockPos fillStart = pos.relative((Direction)state.getValue((Property)ThermoregulatorBlock.FACING));
            blockEntity.filledBlocks.clear();
            AreaFill.fill(level, fillStart, new AreaFill.PositionChecker(){

                @Override
                public void onSolid(Level level, AreaFill.FillPos pos) {
                }

                @Override
                public void onPassable(Level level, AreaFill.FillPos pos) {
                    blockEntity.filledBlocks.add(pos.pos());
                }

                @Override
                public boolean isPassable(Level level, AreaFill.FillPos pos) {
                    BlockState state = level.getBlockState(pos.pos());
                    return this.isConfined(level, pos.pos()) && (state.isAir() || state.is(ModTags.Blocks.PASSABLE_BLOCKS) || !this.isFlowBlocking(level, pos, state));
                }
            }, 16);
            changed = true;
        }
        ++blockEntity.fillTimer;
        if (changed) {
            ThermoregulatorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public Effect getEffectAtPos(BlockPos pos) {
        if (this.filledBlocks.contains(pos)) {
            return this.getEffect();
        }
        return Effect.NONE;
    }

    public ImmutableSet<BlockPos> getFilledBlocks() {
        return ImmutableSet.copyOf(this.filledBlocks);
    }

    public Effect getEffect() {
        boolean cooling = this.isCooling();
        boolean heating = this.isHeating();
        if (cooling && heating) {
            return Effect.NEUTRALIZING;
        }
        if (cooling) {
            return Effect.COOLING;
        }
        if (heating) {
            return Effect.HEATING;
        }
        return Effect.NONE;
    }

    public boolean isCooling() {
        return this.coolingTimeRemaining > 0;
    }

    public boolean isHeating() {
        return this.heatingTimeRemaining > 0;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new ThermoregulatorContainer(id, player, (Container)this, this.dataAccess);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.toughasnails.thermoregulator");
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{0, 1};
        }
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)ThermoregulatorBlock.FACING);
        if (facing.getClockWise() == direction) {
            return new int[]{0};
        }
        if (facing.getCounterClockWise() == direction) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 0) {
            return ThermoregulatorBlockEntity.isCoolingFuel(stack);
        }
        if (index == 1) {
            return ThermoregulatorBlockEntity.isHeatingFuel(stack);
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(index);
        boolean sameItem = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (!sameItem) {
            this.setChanged();
        }
    }

    public void clearContent() {
        this.items.clear();
    }

    public static boolean isCoolingFuel(ItemStack stack) {
        return stack.is(ModTags.Items.THERMOREGULATOR_COOLING_FUEL);
    }

    public static boolean isHeatingFuel(ItemStack stack) {
        return stack.is(ModTags.Items.THERMOREGULATOR_HEATING_FUEL);
    }

    public static enum Effect {
        COOLING,
        HEATING,
        NEUTRALIZING,
        NONE;

    }
}

