/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.block.entity.TemperatureGaugeBlockEntity;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureGaugeBlock
extends BaseEntityBlock {
    public static final MapCodec<TemperatureGaugeBlock> CODEC = TemperatureGaugeBlock.simpleCodec(TemperatureGaugeBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty INVERTED = BlockStateProperties.INVERTED;

    public MapCodec<TemperatureGaugeBlock> codec() {
        return CODEC;
    }

    public TemperatureGaugeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.mayBuild()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.cycle((Property)INVERTED);
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            TemperatureGaugeBlock.updateSignalStrength(blockstate, level, pos);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)POWER);
    }

    public BlockEntity newBlockEntity(BlockPos $$0, BlockState $$1) {
        return new TemperatureGaugeBlockEntity($$0, $$1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide ? TemperatureGaugeBlock.createTickerHelper(type, TANBlockEntityTypes.TEMPERATURE_GAUGE, TemperatureGaugeBlock::tickEntity) : null;
    }

    private static void tickEntity(Level level, BlockPos pos, BlockState state, TemperatureGaugeBlockEntity blockEntity) {
        if (level.getGameTime() % 20L == 0L) {
            TemperatureGaugeBlock.updateSignalStrength(state, level, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER, INVERTED});
    }

    private static void updateSignalStrength(BlockState state, Level level, BlockPos pos) {
        TemperatureLevel temperatureLevel = TemperatureHelperImpl.getTemperatureAtPosWithoutProximity(level, pos);
        int strength = (Boolean)state.getValue((Property)INVERTED) != false ? (Mth.clamp((int)temperatureLevel.ordinal(), (int)2, (int)4) - 2) * 8 - 1 : 15 - Mth.clamp((int)temperatureLevel.ordinal(), (int)0, (int)2) * 8;
        strength = Mth.clamp((int)strength, (int)0, (int)15);
        if ((Integer)state.getValue((Property)POWER) != strength) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(strength)), 3);
        }
    }
}

