/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import toughasnails.api.item.TANItems;

public class RainCollectorBlock
extends Block {
    private static final VoxelShape INSIDE = RainCollectorBlock.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)INSIDE, (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)3);

    public RainCollectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState p_151964_, BlockGetter p_151965_, BlockPos p_151966_, CollisionContext p_151967_) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty() || stack.getItem() != Items.GLASS_BOTTLE) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int waterLevel = (Integer)state.getValue((Property)LEVEL);
        if (waterLevel > 0 && !worldIn.isClientSide) {
            if (!player.getAbilities().instabuild) {
                ItemStack newStack = new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE);
                player.awardStat(Stats.USE_CAULDRON);
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, newStack);
                } else if (!player.getInventory().add(newStack)) {
                    player.drop(newStack, false);
                } else {
                    player.inventoryMenu.sendAllDataToRemote();
                }
            }
            worldIn.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setWaterLevel(worldIn, pos, state, waterLevel - 1);
        }
        return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    public void setWaterLevel(Level world, BlockPos pos, BlockState state, int level) {
        world.setBlock(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(Mth.clamp((int)level, (int)0, (int)3))), 2);
        world.updateNeighbourForOutputSignal(pos, (Block)this);
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (RainCollectorBlock.shouldHandlePrecipitation(level, precipitation) && (Integer)state.getValue((Property)LEVEL) < 3) {
            level.setBlock(pos, (BlockState)state.cycle((Property)LEVEL), 2);
        }
    }

    protected static boolean shouldHandlePrecipitation(Level level, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return level.getRandom().nextFloat() < 0.6f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return level.getRandom().nextFloat() < 0.3f;
        }
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }
}

