/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EnhancedSkullBlockTile
extends BlockEntity {
    @Nullable
    protected SkullBlockEntity innerTile = null;

    public EnhancedSkullBlockTile(BlockEntityType type, BlockPos pWorldPosition, BlockState pBlockState) {
        super(type, pWorldPosition, pBlockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveInnerTile("Skull", this.innerTile, tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.innerTile = this.loadInnerTile("Skull", this.innerTile, tag, registries);
    }

    protected void saveInnerTile(String tagName, @Nullable SkullBlockEntity tile, CompoundTag tag, HolderLookup.Provider registries) {
        if (tile != null) {
            tag.put(tagName + "State", (Tag)NbtUtils.writeBlockState((BlockState)tile.getBlockState()));
            tag.put(tagName, (Tag)tile.saveWithFullMetadata(registries));
        }
    }

    @Nullable
    protected SkullBlockEntity loadInnerTile(String tagName, @Nullable SkullBlockEntity tile, CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains(tagName)) {
            BlockState state = Utils.readBlockState((CompoundTag)tag.getCompound(tagName + "State"), (Level)this.level);
            CompoundTag tileTag = tag.getCompound(tagName);
            if (tile == null) {
                BlockEntity newTile = BlockEntity.loadStatic((BlockPos)this.getBlockPos(), (BlockState)state, (CompoundTag)tileTag, (HolderLookup.Provider)registries);
                if (newTile instanceof SkullBlockEntity) {
                    SkullBlockEntity skullTile = (SkullBlockEntity)newTile;
                    return skullTile;
                }
            } else {
                tile.loadWithComponents(tileTag, registries);
                return tile;
            }
        }
        return null;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ItemStack getSkullItem() {
        if (this.innerTile != null) {
            return new ItemStack((ItemLike)this.innerTile.getBlockState().getBlock());
        }
        return ItemStack.EMPTY;
    }

    public void initialize(SkullBlockEntity oldTile, ItemStack stack, Player player, InteractionHand hand) {
        RegistryAccess registries = player.level().registryAccess();
        this.innerTile = (SkullBlockEntity)oldTile.getType().create(this.getBlockPos(), oldTile.getBlockState());
        if (this.innerTile != null) {
            this.innerTile.loadWithComponents(oldTile.saveWithoutMetadata((HolderLookup.Provider)registries), (HolderLookup.Provider)registries);
        }
    }

    @Nullable
    public BlockState getSkull() {
        if (this.innerTile != null) {
            return this.innerTile.getBlockState();
        }
        return null;
    }

    @Nullable
    public BlockEntity getSkullTile() {
        return this.innerTile;
    }

    protected void tick(Level level, BlockPos pos, BlockState state) {
        BlockState b;
        if (this.innerTile != null && (b = this.innerTile.getBlockState()) instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)b;
            eb.getTicker(level, b, this.innerTile.getType());
        }
    }
}

