/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import com.mojang.serialization.DynamicOps;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.mutantmonsters.world.level.ZombieResurrection;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MutantZombie
extends AbstractMutantMonster
implements AnimatedEntity {
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final EntityAnimation SLAM_GROUND_ANIMATION = new EntityAnimation(25);
    public static final EntityAnimation THROW_ANIMATION = new EntityAnimation(15);
    public static final EntityAnimation ROAR_ANIMATION = new EntityAnimation(120);
    private static final EntityDataAccessor<Integer> LIVES = SynchedEntityData.defineId(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> THROW_ATTACK_STATE = SynchedEntityData.defineId(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private final List<SeismicWave> seismicWaveList;
    private final List<ZombieResurrection> resurrectionList;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;
    private DamageSource deathCause;

    public MutantZombie(EntityType<? extends MutantZombie> type, Level worldIn) {
        super(type, worldIn);
        this.seismicWaveList = new ArrayList<SeismicWave>();
        this.resurrectionList = new ArrayList<ZombieResurrection>();
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantZombie.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SlamGroundGoal(this));
        this.goalSelector.addGoal(0, (Goal)new RoarGoal(this));
        this.goalSelector.addGoal(0, (Goal)new ThrowAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(0));
        this.goalSelector.addGoal(2, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, WitherBoss.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIVES, (Object)3);
        builder.define(THROW_ATTACK_STATE, (Object)0);
    }

    public int getRemainingLives() {
        return (Integer)this.entityData.get(LIVES);
    }

    private void setRemainingLives(int lives) {
        this.entityData.set(LIVES, (Object)lives);
    }

    public boolean hasThrowAttackHit() {
        return ((Byte)this.entityData.get(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.entityData.get(THROW_ATTACK_STATE);
        this.entityData.set(THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.entityData.get(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.entityData.get(THROW_ATTACK_STATE);
        this.entityData.set(THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float tickHeadTurn(float renderYawOffset, float distance) {
        return this.deathTime > 0 ? distance : super.tickHeadTurn(renderYawOffset, distance);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxFallDistance() {
        return this.getTarget() != null ? (int)this.distanceTo((Entity)this.getTarget()) : 3;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack itemInHandCopy = itemInHand.copy();
        InteractionResult interactionResult = this.deadMobInteract(player, hand);
        if (interactionResult.consumesAction()) {
            if (player.getAbilities().instabuild && itemInHand == player.getItemInHand(hand) && itemInHand.getCount() < itemInHandCopy.getCount()) {
                itemInHand.setCount(itemInHandCopy.getCount());
            }
            if (itemInHand.isEmpty() && !player.getAbilities().instabuild) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            return interactionResult;
        }
        return super.interactAt(player, vec, hand);
    }

    private InteractionResult deadMobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is(ItemTags.CREEPER_IGNITERS) && !this.isAlive() && !this.isOnFire() && !this.isInWaterOrRain()) {
            this.level().playSound(player, this.getX(), this.getY(), this.getZ(), SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide) {
                this.igniteForSeconds(8.0f);
                if (!itemInHand.isDamageableItem()) {
                    itemInHand.shrink(1);
                } else {
                    ItemHelper.hurtAndBreak((ItemStack)itemInHand, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)itemInHand.getItem()));
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void igniteForTicks(int ticks) {
        super.igniteForTicks(ticks);
        if (this.level() instanceof ServerLevel && this.isDeadOrDying()) {
            this.setRemainingLives(0);
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (!this.isAnimationPlaying()) {
            if (entityIn.getVehicle() != this && this.random.nextInt(5) != 0) {
                if (this.onGround() || !this.getInBlockState().getFluidState().isEmpty()) {
                    this.animation = SLAM_GROUND_ANIMATION;
                }
            } else {
                this.animation = THROW_ANIMATION;
            }
        }
        return true;
    }

    protected void customServerAiStep() {
        if (!this.isAnimationPlaying() && this.getTarget() != null && Math.abs(this.getY() - this.getTarget().getY()) <= 1.0 && this.distanceToSqr((Entity)this.getTarget()) <= 49.0 && this.random.nextInt(20) == 0) {
            this.animation = SLAM_GROUND_ANIMATION;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        return (entity == null || this.canHarm(entity) && (this.animation != THROW_ANIMATION || entity != this.getTarget())) && super.hurt(source, amount);
    }

    protected void updateNoActionTime() {
    }

    public void tick() {
        super.tick();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (this.level().isNight() && this.tickCount % 100 == 0 && this.isAlive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.getHealth() > 0.0f) {
            this.deathTime = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.yHeadRot - this.yBodyRot; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.yBodyRot += yaw * offset;
    }

    private void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.level().isClientSide) {
            if (this.animation == THROW_ANIMATION) {
                if (this.hasThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.isThrowAttackFinished()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.level(), (Entity)this);
            AABB box = new AABB((double)wave.getX(), (double)wave.getY() + 1.0, (double)wave.getZ(), (double)wave.getX() + 1.0, (double)wave.getY() + 2.0, (double)wave.getZ() + 1.0);
            if (wave.isFirst()) {
                double addScale = this.random.nextDouble() * 0.75;
                box = box.inflate(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            DamageSource source = DamageSourcesHelper.source((LevelReader)this.level(), ModRegistry.MUTANT_ZOMBIE_SEISMIC_WAVE_DAMAGE_TYPE, (Entity)this);
            for (Entity entity : this.level().getEntities((Entity)this, box, EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(this::canHarm))) {
                if (entity instanceof LivingEntity && entity.hurt(source, wave.isFirst() ? (float)(9 + this.random.nextInt(4)) : (float)(6 + this.random.nextInt(3))) && this.random.nextInt(5) == 0) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.HUNGER, 160, 1));
                }
                double x = entity.getX() - this.getX();
                double z = entity.getZ() - this.getZ();
                double d = Math.sqrt(x * x + z * z);
                entity.setDeltaMovement(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
        }
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(1.0);
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByShield(LivingEntity livingEntity) {
        livingEntity.hurtMarked = true;
    }

    public void die(DamageSource damageSource) {
        if (!this.level().isClientSide) {
            if (this.isOnFire()) {
                this.setRemainingLives(0);
            }
            this.deathCause = damageSource;
            for (WrappedGoal goal : this.goalSelector.getAvailableGoals()) {
                if (!goal.isRunning()) continue;
                goal.stop();
            }
            this.setLastHurtMob((Entity)this.getLastHurtByMob());
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (this.lastHurtByPlayerTime > 0) {
                this.lastHurtByPlayerTime += 140;
            }
        }
    }

    protected void tickDeath() {
        if (this.getRemainingLives() > 0) {
            if (++this.deathTime >= 140) {
                this.deathTime = 0;
                this.deathCause = null;
                this.setHealth(this.getMaxHealth() / 4.0f);
                this.setRemainingLives(this.getRemainingLives() - 1);
            }
        } else {
            if (this.deathTime > 100) {
                --this.deathTime;
            } else if (this.deathTime < 100) {
                ++this.deathTime;
            }
            if (++this.vanishTime >= 100) {
                DamageSource killedByDamageSource = this.deathCause;
                super.die(killedByDamageSource != null ? killedByDamageSource : this.damageSources().generic());
                super.tickDeath();
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 60) {
            this.makePoofParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void makePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)(this.isOnFire() ? ParticleTypes.FLAME : ParticleTypes.POOF), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public void kill() {
        super.kill();
        this.setRemainingLives(0);
    }

    private boolean canHarm(Entity entity) {
        return entity.getType() != EntityType.ZOMBIE && entity.getType() != EntityType.ZOMBIE_VILLAGER && entity.getType() != EntityType.HUSK && entity.getType() != EntityType.DROWNED && !(entity instanceof MutantZombie);
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        boolean bl = super.killedEntity(level, entity);
        if ((level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) && entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                return bl;
            }
            ZombieVillager zombieVillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false);
            if (zombieVillager != null) {
                zombieVillager.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zombieVillager.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
                zombieVillager.setVillagerData(villager.getVillagerData());
                zombieVillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                zombieVillager.setTradeOffers(villager.getOffers().copy());
                zombieVillager.setVillagerXp(villager.getVillagerXp());
                if (!this.isSilent()) {
                    level.levelEvent(null, 1026, this.blockPosition(), 0);
                }
                bl = false;
            }
        }
        return bl;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Lives", this.getRemainingLives());
        compound.putShort("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (ZombieResurrection resurrection : this.resurrectionList) {
                CompoundTag compoundNBT = new CompoundTag();
                compoundNBT.put("ResurrectionPosition", NbtUtils.writeBlockPos((BlockPos)resurrection));
                compoundNBT.putInt("Tick", resurrection.getTick());
                listnbt.add((Object)compoundNBT);
            }
            compound.put("Resurrections", (Tag)listnbt);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Lives")) {
            this.setRemainingLives(compound.getInt("Lives"));
        }
        this.vanishTime = compound.getShort("VanishTime");
        ListTag listNBT = compound.getList("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag compoundNBT = listNBT.getCompound(i);
            Optional optional = NbtUtils.readBlockPos((CompoundTag)compoundNBT, (String)"ResurrectionPosition");
            optional.ifPresent(blockPos -> this.resurrectionList.add(new ZombieResurrection((BlockPos)blockPos, compoundNBT.getInt("Tick"))));
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH_SOUND_EVENT.value();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        if (this.deathTime == 0) {
            this.playSound(SoundEvents.ZOMBIE_STEP, 0.15f, 1.0f);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.writeVarInt(this.deathTime);
        buffer.writeVarInt(this.vanishTime);
        buffer.writeVarInt(this.throwHitTick);
        buffer.writeVarInt(this.throwFinishTick);
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.deathTime = additionalData.readVarInt();
        this.vanishTime = additionalData.readVarInt();
        this.throwHitTick = additionalData.readVarInt();
        this.throwFinishTick = additionalData.readVarInt();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombie> {
        private double dirX = -1.0;
        private double dirZ = -1.0;

        public SlamGroundGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            ((MutantZombie)this.mob).ambientSoundTime = -((MutantZombie)this.mob).getAmbientSoundInterval();
            ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK_SOUND_EVENT.value(), 0.3f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
        }

        public void tick() {
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                ((MutantZombie)this.mob).getNavigation().stop();
                if (((MutantZombie)this.mob).animationTick < 8) {
                    ((MutantZombie)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantZombie)this.mob).animationTick == 8) {
                    double x = target.getX() - ((MutantZombie)this.mob).getX();
                    double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                    double d = Math.sqrt(x * x + z * z);
                    this.dirX = x / d;
                    this.dirZ = z / d;
                }
                if (((MutantZombie)this.mob).animationTick == 12) {
                    int x = Mth.floor((double)(((MutantZombie)this.mob).getX() + this.dirX * 2.0));
                    int y = Mth.floor((double)((MutantZombie)this.mob).getBoundingBox().minY);
                    int z = Mth.floor((double)(((MutantZombie)this.mob).getZ() + this.dirZ * 2.0));
                    int x1 = Mth.floor((double)(((MutantZombie)this.mob).getX() + this.dirX * 8.0));
                    int z1 = Mth.floor((double)(((MutantZombie)this.mob).getZ() + this.dirZ * 8.0));
                    SeismicWave.createWaves(((MutantZombie)this.mob).level(), ((MutantZombie)this.mob).seismicWaveList, x, z, x1, z1, y);
                    ((MutantZombie)this.mob).playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 0.5f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.dirX = -1.0;
            this.dirZ = -1.0;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombie> {
        public RoarGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).tickCount % 3 == 0 && !((MutantZombie)this.mob).isAnimationPlaying() && ((MutantZombie)this.mob).getTarget() != null && ((MutantZombie)this.mob).onGround() && ((MutantZombie)this.mob).resurrectionList.isEmpty() && ((MutantZombie)this.mob).distanceToSqr((Entity)((MutantZombie)this.mob).getTarget()) > 16.0 && ((MutantZombie)this.mob).random.nextFloat() * 100.0f < 0.35f;
        }

        @Override
        public void start() {
            super.start();
            ((MutantZombie)this.mob).invulnerableTime = 20;
            ((MutantZombie)this.mob).ambientSoundTime = -((MutantZombie)this.mob).getAmbientSoundInterval();
        }

        public void tick() {
            ((MutantZombie)this.mob).getNavigation().stop();
            if (((MutantZombie)this.mob).animationTick < 75 && ((MutantZombie)this.mob).getTarget() != null) {
                ((MutantZombie)this.mob).lookControl.setLookAt((Entity)((MutantZombie)this.mob).getTarget(), 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 10) {
                ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR_SOUND_EVENT.value(), 3.0f, 0.7f + ((MutantZombie)this.mob).random.nextFloat() * 0.2f);
                for (Entity entity : ((MutantZombie)this.mob).level().getEntities((Entity)this.mob, ((MutantZombie)this.mob).getBoundingBox().inflate(12.0, 8.0, 12.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR)) {
                    if (!((MutantZombie)this.mob).canHarm(entity) || !(((MutantZombie)this.mob).distanceToSqr(entity) <= 196.0)) continue;
                    double x = entity.getX() - ((MutantZombie)this.mob).getX();
                    double z = entity.getZ() - ((MutantZombie)this.mob).getZ();
                    double d = Math.sqrt(x * x + z * z);
                    entity.setDeltaMovement(x / d * 0.7, 0.3, z / d * 0.7);
                    entity.hurt(DamageSourcesHelper.source((LevelReader)((MutantZombie)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), (float)(2 + ((MutantZombie)this.mob).random.nextInt(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombie)this.mob).animationTick >= 20 && ((MutantZombie)this.mob).animationTick < 80 && ((MutantZombie)this.mob).animationTick % 10 == 0) {
                int x = Mth.floor((double)((MutantZombie)this.mob).getX());
                int y = Mth.floor((double)((MutantZombie)this.mob).getBoundingBox().minY);
                int z = Mth.floor((double)((MutantZombie)this.mob).getZ());
                y = ZombieResurrection.getSuitableGround(((MutantZombie)this.mob).level(), x += (1 + ((MutantZombie)this.mob).random.nextInt(8)) * (((MutantZombie)this.mob).random.nextBoolean() ? 1 : -1), y - 1, z += (1 + ((MutantZombie)this.mob).random.nextInt(8)) * (((MutantZombie)this.mob).random.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombie)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombie)this.mob).level(), x, y, z));
                }
            }
        }
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombie> {
        private int finish = -1;

        public ThrowAttackGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                target.stopRiding();
                double x = target.getX() - ((MutantZombie)this.mob).getX();
                double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                double d = Math.sqrt(x * x + z * z);
                target.setDeltaMovement(x / d * 0.8, 1.6, z / d * 0.8);
                EntityUtil.sendPlayerVelocityPacket((Entity)target);
            }
        }

        @Override
        public boolean canContinueToUse() {
            if (this.finish >= 10) {
                return false;
            }
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target == null) {
                return false;
            }
            if (!target.isAlive()) {
                return false;
            }
            return !(target instanceof Player) || !target.isSpectator() && !((Player)target).isCreative();
        }

        public void tick() {
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                ((MutantZombie)this.mob).getNavigation().stop();
                ((MutantZombie)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                if (((MutantZombie)this.mob).animationTick == THROW_ANIMATION.duration()) {
                    ((MutantZombie)this.mob).stuckSpeedMultiplier = Vec3.ZERO;
                    double d1 = target.getX() - ((MutantZombie)this.mob).getX();
                    double d2 = target.getY() - ((MutantZombie)this.mob).getY();
                    double x = target.getZ() - ((MutantZombie)this.mob).getZ();
                    double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                    ((MutantZombie)this.mob).setDeltaMovement(d1 / z * 3.4, d2 / z * 1.4, x / z * 3.4);
                } else if (((MutantZombie)this.mob).animationTick > THROW_ANIMATION.duration()) {
                    double d1 = ((MutantZombie)this.mob).getBbWidth() * 2.0f * ((MutantZombie)this.mob).getBbWidth() * 2.0f;
                    double d2 = ((MutantZombie)this.mob).distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
                    if (d2 < d1 && !((MutantZombie)this.mob).hasThrowAttackHit()) {
                        ((MutantZombie)this.mob).setThrowAttackHit(true);
                        if (!target.hurt(((MutantZombie)this.mob).level().damageSources().mobAttack((LivingEntity)this.mob), (float)((MutantZombie)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE))) {
                            EntityUtil.disableShield(target, 150);
                        }
                        double x = target.getX() - ((MutantZombie)this.mob).getX();
                        double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                        double d = Math.sqrt(x * x + z * z);
                        target.setDeltaMovement(x / d * 0.6, -1.2, z / d * 0.6);
                        target.invulnerableTime = 10;
                        EntityUtil.sendPlayerVelocityPacket((Entity)target);
                        EntityUtil.stunRavager(target);
                        ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT_SOUND_EVENT.value(), 0.3f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
                    }
                    if (!(!((MutantZombie)this.mob).onGround() && ((MutantZombie)this.mob).getInBlockState().getFluidState().isEmpty() || ((MutantZombie)this.mob).isThrowAttackFinished())) {
                        this.finish = 0;
                        ((MutantZombie)this.mob).setThrowAttackFinished(true);
                    }
                    if (this.finish >= 0) {
                        ++this.finish;
                    }
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.finish = -1;
            ((MutantZombie)this.mob).setThrowAttackHit(false);
            ((MutantZombie)this.mob).setThrowAttackFinished(false);
        }
    }
}

