/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.CreeperMinionEgg;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantCreeper
extends AbstractMutantMonster {
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.defineId(MutantCreeper.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private int lastJumpTick;
    private int jumpTick;
    private boolean summonLightning;
    private DamageSource deathCause;

    public MutantCreeper(EntityType<? extends MutantCreeper> type, Level worldIn) {
        super(type, worldIn);
        this.chargeHits = 3 + this.random.nextInt(3);
        this.xpReward = 30;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new JumpAttackGoal());
        this.goalSelector.addGoal(1, (Goal)new SpawnMinionsGoal());
        this.goalSelector.addGoal(1, (Goal)new ChargeAttackGoal());
        this.goalSelector.addGoal(2, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(200));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 100, true, true, EntityUtil::isFeline));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantCreeper.createMonsterAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATUS, (Object)0);
    }

    public boolean isCharged() {
        return ((Byte)this.entityData.get(STATUS) & 1) != 0;
    }

    private void setCharged(boolean charged) {
        byte b0 = (Byte)this.entityData.get(STATUS);
        this.entityData.set(STATUS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.entityData.get(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.entityData.get(STATUS);
        this.entityData.set(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.entityData.get(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.entityData.get(STATUS);
        this.entityData.set(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    public boolean fireImmune() {
        return this.isCharged() || super.fireImmune();
    }

    public boolean doHurtTarget(Entity target) {
        double z;
        double y;
        double x;
        double d;
        Level level;
        DamageSource damageSource = this.level().damageSources().mobAttack((LivingEntity)this);
        boolean hurt = target.hurt(damageSource, (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
        if (hurt && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
        }
        if ((d = Math.sqrt((x = target.getX() - this.getX()) * x + (y = target.getY() - this.getY()) * y + (z = target.getZ() - this.getZ()) * z)) > 0.0) {
            target.push(x / d * 0.5, y / d * 0.05 + 0.15, z / d * 0.5);
        }
        this.swing(InteractionHand.MAIN_HAND);
        return hurt;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            float healAmount = amount / 2.0f;
            if (this.isAlive() && this.getHealth() < this.getMaxHealth() && !(source.getEntity() instanceof MutantCreeper)) {
                this.heal(healAmount);
                EntityUtil.sendParticlePacket((Entity)this, (ParticleOptions)ParticleTypes.HEART, (int)(healAmount / 2.0f));
            }
            return false;
        }
        boolean takenDamage = super.hurt(source, amount);
        if (this.isCharging()) {
            if (!source.is(DamageTypeTags.WITCH_RESISTANT_TO) && source.getDirectEntity() instanceof LivingEntity) {
                source.getDirectEntity().hurt(this.damageSources().thorns((Entity)this), 2.0f);
            }
            if (takenDamage && amount > 0.0f) {
                --this.chargeHits;
            }
        }
        return takenDamage;
    }

    public double getVisibilityPercent(@Nullable Entity lookingEntity) {
        return !(lookingEntity instanceof IronGolem) && !(lookingEntity instanceof Zoglin) ? super.getVisibilityPercent(lookingEntity) : 0.0;
    }

    public void thunderHit(ServerLevel serverWorld, LightningBolt lightningBolt) {
        this.setCharged(true);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected void updateNoActionTime() {
    }

    public void handleEntityEvent(byte id) {
        if (id == 6) {
            for (int i = 0; i < 15; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        super.tick();
        this.lastJumpTick = this.jumpTick;
        if (this.isJumpAttacking()) {
            if (this.jumpTick == 0) {
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_PRIMED_SOUND_EVENT.value(), this.getSoundSource(), 2.0f, this.getVoicePitch());
            }
            ++this.jumpTick;
            this.stuckSpeedMultiplier = Vec3.ZERO;
            if (!(this.level().isClientSide || !this.onGround() && this.getInBlockState().getFluidState().isEmpty())) {
                float sizeIn = this.isCharged() ? 6.0f : 4.0f;
                MutatedExplosionHelper.explode((Entity)this, sizeIn, false, Level.ExplosionInteraction.MOB);
                this.setJumpAttacking(false);
            }
        } else if (this.jumpTick > 0) {
            this.jumpTick = 0;
        }
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByShield(LivingEntity livingEntity) {
        livingEntity.hurtMarked = true;
    }

    public float getOverlayColor(float partialTicks) {
        if (this.deathTime > 0) {
            return (float)this.deathTime / 100.0f;
        }
        if (this.isCharging()) {
            return this.tickCount % 20 < 10 ? 0.6f : 0.0f;
        }
        return Mth.lerp((float)partialTicks, (float)this.lastJumpTick, (float)this.jumpTick) / 28.0f;
    }

    public void die(DamageSource cause) {
        if (!this.level().isClientSide) {
            this.deathCause = cause;
            this.setCharging(false);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_DEATH_SOUND_EVENT.value(), this.getSoundSource(), 2.0f, 1.0f);
            if (this.lastHurtByPlayerTime > 0) {
                this.lastHurtByPlayerTime += 100;
            }
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(0.0);
        float power = this.isCharged() ? 12.0f : 8.0f;
        float radius = power * 1.5f;
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)radius), EntitySelector.NO_CREATIVE_OR_SPECTATOR)) {
            double x = this.getX() - entity.getX();
            double y = this.getY() - entity.getY();
            double z = this.getZ() - entity.getZ();
            double d = Math.sqrt(x * x + y * y + z * z);
            float scale = (float)this.deathTime / 100.0f;
            entity.setDeltaMovement(entity.getDeltaMovement().add(x / d * (double)scale * 0.09, y / d * (double)scale * 0.09, z / d * (double)scale * 0.09));
        }
        this.setPosRaw(this.getX() + (double)(this.random.nextFloat() * 0.2f) - (double)0.1f, this.getY(), this.getZ() + (double)(this.random.nextFloat() * 0.2f) - (double)0.1f);
        if (this.deathTime >= 100) {
            if (!this.level().isClientSide) {
                boolean causesFireIn = this.isOnFire();
                MutatedExplosionHelper.explode((Entity)this, power, causesFireIn, Level.ExplosionInteraction.MOB);
                super.die(this.deathCause != null ? this.deathCause : this.damageSources().generic());
                if (this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && this.lastHurtByPlayer != null && this.lastHurtByPlayerTime > 0) {
                    this.level().addFreshEntity((Entity)new CreeperMinionEgg(this, (Entity)this.lastHurtByPlayer));
                }
            }
            this.discard();
        }
    }

    public float getBlockExplosionResistance(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, FluidState fluidState, float resistance) {
        return this.isCharged() && blockStateIn.getDestroySpeed(worldIn, pos) > -1.0f ? Math.min(0.8f, resistance) : resistance;
    }

    public void playAmbientSound() {
        if (this.getTarget() == null) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_HURT_SOUND_EVENT.value();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("JumpAttacking", this.isJumpAttacking());
        compound.putBoolean("Charging", this.isCharging());
        compound.putInt("ChargeTime", this.chargeTime);
        compound.putInt("ChargeHits", this.chargeHits);
        compound.putBoolean("SummonLightning", this.summonLightning);
        if (this.isCharged()) {
            compound.putBoolean("Powered", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCharged(compound.getBoolean("powered") || compound.getBoolean("Powered"));
        this.setJumpAttacking(compound.getBoolean("JumpAttacking"));
        this.setCharging(compound.getBoolean("Charging"));
        this.chargeTime = compound.getInt("ChargeTime");
        this.chargeHits = compound.getInt("ChargeHits");
        this.summonLightning = compound.getBoolean("SummonLightning");
    }

    class JumpAttackGoal
    extends Goal {
        JumpAttackGoal() {
        }

        public boolean canUse() {
            LivingEntity target = MutantCreeper.this.getTarget();
            return target != null && MutantCreeper.this.onGround() && MutantCreeper.this.distanceToSqr((Entity)target) <= 1024.0 && !MutantCreeper.this.isJumpAttacking() && !MutantCreeper.this.isCharging() && MutantCreeper.this.random.nextFloat() * 100.0f < 0.9f;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            MutantCreeper.this.setJumpAttacking(true);
            MutantCreeper.this.setDeltaMovement((MutantCreeper.this.getTarget().getX() - MutantCreeper.this.getX()) * 0.2, 1.4 * (double)MutantCreeper.this.getBlockJumpFactor(), (MutantCreeper.this.getTarget().getZ() - MutantCreeper.this.getZ()) * 0.2);
        }
    }

    class SpawnMinionsGoal
    extends Goal {
        SpawnMinionsGoal() {
        }

        public boolean canUse() {
            float chance = MutantCreeper.this.isPathFinding() && (MutantCreeper.this.getLastDamageSource() == null || !MutantCreeper.this.getLastDamageSource().is(DamageTypeTags.IS_PROJECTILE)) ? 0.6f : 0.9f;
            return MutantCreeper.this.getTarget() != null && MutantCreeper.this.distanceToSqr((Entity)MutantCreeper.this.getTarget()) <= 1024.0 && !MutantCreeper.this.isCharging() && !MutantCreeper.this.isJumpAttacking() && MutantCreeper.this.random.nextFloat() * 100.0f < chance;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            for (int i = (int)Math.ceil((double)(MutantCreeper.this.getHealth() / MutantCreeper.this.getMaxHealth()) * 4.0); i > 0; --i) {
                CreeperMinion minion = (CreeperMinion)((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value()).create(MutantCreeper.this.level());
                double x = MutantCreeper.this.getX() + (double)MutantCreeper.this.random.nextFloat() - (double)MutantCreeper.this.random.nextFloat();
                double y = MutantCreeper.this.getY() + (double)(MutantCreeper.this.random.nextFloat() * 0.5f);
                double z = MutantCreeper.this.getZ() + (double)MutantCreeper.this.random.nextFloat() - (double)MutantCreeper.this.random.nextFloat();
                double xx = MutantCreeper.this.getTarget().getX() - MutantCreeper.this.getX();
                double yy = MutantCreeper.this.getTarget().getY() - MutantCreeper.this.getY();
                double zz = MutantCreeper.this.getTarget().getZ() - MutantCreeper.this.getZ();
                minion.setDeltaMovement(xx * 0.15 + (double)(MutantCreeper.this.random.nextFloat() * 0.05f), yy * 0.15 + (double)(MutantCreeper.this.random.nextFloat() * 0.05f), zz * 0.15 + (double)(MutantCreeper.this.random.nextFloat() * 0.05f));
                minion.setPos(x, y, z);
                minion.setTarget(MutantCreeper.this.getTarget());
                minion.setOwnerUUID(MutantCreeper.this.uuid);
                if (MutantCreeper.this.isCharged()) {
                    minion.setCharged(true);
                }
                MutantCreeper.this.level().addFreshEntity((Entity)minion);
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity target = MutantCreeper.this.getTarget();
            return target != null && !MutantCreeper.this.isJumpAttacking() && !(MutantCreeper.this.getMaxHealth() - MutantCreeper.this.getHealth() < MutantCreeper.this.getMaxHealth() / 6.0f) && MutantCreeper.this.distanceToSqr((Entity)target) >= 25.0 && MutantCreeper.this.distanceToSqr((Entity)target) <= 1024.0 && MutantCreeper.this.random.nextFloat() * 100.0f < 0.7f || MutantCreeper.this.isCharging();
        }

        public boolean canContinueToUse() {
            LivingEntity target = MutantCreeper.this.getTarget();
            if (MutantCreeper.this.summonLightning && target != null && MutantCreeper.this.distanceToSqr((Entity)target) < 25.0) {
                return false;
            }
            return MutantCreeper.this.chargeTime < 100 && MutantCreeper.this.chargeHits > 0;
        }

        public void start() {
            MutantCreeper.this.setCharging(true);
            if (MutantCreeper.this.random.nextInt(MutantCreeper.this.level().isThundering() ? 2 : 6) == 0 && !MutantCreeper.this.isCharged()) {
                MutantCreeper.this.summonLightning = true;
            }
        }

        public void tick() {
            MutantCreeper.this.getNavigation().stop();
            int i = MutantCreeper.this.chargeTime % 20;
            if (i == 0) {
                MutantCreeper.this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_CREEPER_CHARGE_SOUND_EVENT.value(), 0.6f, 0.7f + MutantCreeper.this.random.nextFloat() * 0.6f);
            }
            ++MutantCreeper.this.chargeTime;
        }

        public void stop() {
            if (MutantCreeper.this.summonLightning && MutantCreeper.this.getTarget() != null && MutantCreeper.this.distanceToSqr((Entity)MutantCreeper.this.getTarget()) < 25.0 && MutantCreeper.this.level().canSeeSky(MutantCreeper.this.blockPosition())) {
                LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(MutantCreeper.this.level());
                lightningBoltEntity.moveTo(MutantCreeper.this.getX(), MutantCreeper.this.getY(), MutantCreeper.this.getZ());
                MutantCreeper.this.level().addFreshEntity((Entity)lightningBoltEntity);
            } else if (MutantCreeper.this.chargeTime >= 100) {
                MutantCreeper.this.heal(30.0f);
                MutantCreeper.this.level().broadcastEntityEvent((Entity)MutantCreeper.this, (byte)6);
            }
            MutantCreeper.this.chargeTime = 0;
            MutantCreeper.this.chargeHits = 4 + MutantCreeper.this.random.nextInt(3);
            MutantCreeper.this.setCharging(false);
            MutantCreeper.this.summonLightning = false;
        }
    }
}

