/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class MutantMeleeAttackGoal
extends MeleeAttackGoal {
    protected int maxAttackTick = 20;
    protected final double moveSpeed;
    protected int ticksUntilNextPathRecalculation;
    protected int attackTick;

    public MutantMeleeAttackGoal(PathfinderMob creatureEntity, double moveSpeed) {
        super(creatureEntity, moveSpeed, true);
        this.moveSpeed = moveSpeed;
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            this.mob.setTarget(null);
            return false;
        }
        return true;
    }

    public void start() {
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                this.mob.getNavigation().moveTo((Entity)livingentity, this.moveSpeed);
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(livingentity);
        }
    }

    protected void resetAttackCooldown() {
        this.attackTick = this.maxAttackTick;
    }

    protected boolean isTimeToAttack() {
        return this.attackTick <= 0;
    }

    protected boolean canPerformAttack(LivingEntity entity) {
        return (this.mob.isWithinMeleeAttackRange(entity) || this.mob.getBoundingBox().intersects(entity.getBoundingBox())) && this.isTimeToAttack() && this.mob.getSensing().hasLineOfSight((Entity)entity);
    }

    public void stop() {
        this.mob.getNavigation().stop();
        if (this.mob.getTarget() == null) {
            this.mob.setAggressive(false);
        }
    }

    public MutantMeleeAttackGoal setMaxAttackTick(int max) {
        this.maxAttackTick = max;
        return this;
    }
}

