/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class EndersoulFragment
extends Entity {
    public static final Predicate<Entity> IS_VALID_TARGET = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(entity -> {
        EntityType type = entity.getType();
        return type != EntityType.ITEM && type != EntityType.EXPERIENCE_ORB && type != EntityType.END_CRYSTAL && type != EntityType.ENDER_DRAGON && type != EntityType.ENDERMAN && type != ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value() && type != ModEntityTypes.ENDERSOUL_FRAGMENT_ENTITY_TYPE.value() && type != ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.value();
    });
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.defineId(EndersoulFragment.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.random.nextInt(20);
    private WeakReference<MutantEnderman> spawner;
    private Player owner;

    public EndersoulFragment(EntityType<? extends EndersoulFragment> type, Level world) {
        super(type, world);
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.random.nextFloat() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragment(Level world, MutantEnderman spawner) {
        this((EntityType<? extends EndersoulFragment>)((EntityType)ModEntityTypes.ENDERSOUL_FRAGMENT_ENTITY_TYPE.value()), world);
        this.spawner = new WeakReference<MutantEnderman>(spawner);
    }

    public static boolean isProtected(Entity entity) {
        return entity instanceof LivingEntity && ((LivingEntity)entity).isHolding((Item)ModItems.ENDERSOUL_HAND_ITEM.value());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TAMED, (Object)false);
    }

    public Player getOwner() {
        return this.owner;
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.entityData.set(TAMED, (Object)tamed);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, this.random, 64, 0.8f);
        }
    }

    public void tick() {
        super.tick();
        Vec3 vec3d = this.getDeltaMovement();
        if (this.owner == null && vec3d.y > (double)-0.05f && !this.isNoGravity()) {
            this.setDeltaMovement(vec3d.x, Math.max((double)-0.05f, vec3d.y - (double)0.1f), vec3d.z);
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        if (this.owner != null && (!this.owner.isAlive() || this.owner.isSpectator())) {
            this.owner = null;
        }
        if (!this.level().isClientSide) {
            if (!this.isTamed() && --this.explodeTick == 0) {
                this.explode();
            }
            if (this.owner != null && this.distanceToSqr((Entity)this.owner) > 9.0) {
                float scale = 0.05f;
                this.push((this.owner.getX() - this.getX()) * (double)scale, (this.owner.getY() + (double)(this.owner.getEyeHeight() / 3.0f) - this.getY()) * (double)scale, (this.owner.getZ() - this.getZ()) * (double)scale);
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isTamed()) {
            if (this.owner == null && !player.isSecondaryUseActive()) {
                this.owner = player;
                this.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.owner == player && player.isSecondaryUseActive()) {
                this.owner = null;
                this.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 1.5f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            this.setTamed(true);
        }
        this.owner = player;
        this.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 1.5f);
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && this.isAlive() && this.tickCount > 0) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE_SOUND_EVENT.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(5.0), IS_VALID_TARGET)) {
            boolean hitChance;
            if (!(this.distanceToSqr(entity) <= 25.0)) continue;
            boolean bl = hitChance = this.random.nextInt(3) != 0;
            if (EndersoulFragment.isProtected(entity)) {
                hitChance = this.random.nextInt(3) == 0;
            } else {
                double x = entity.getX() - this.getX();
                double z = entity.getZ() - this.getZ();
                double d = Math.sqrt(x * x + z * z);
                entity.setDeltaMovement(0.8 * x / d, (double)(this.random.nextFloat() * 0.6f - 0.1f), 0.8 * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            entity.hurt(DamageSourcesHelper.source((LevelReader)this.level(), ModRegistry.ENDERSOUL_FRAGMENT_EXPLOSION_DAMAGE_TYPE, (Entity)this, (Entity)(this.spawner != null ? (Entity)this.spawner.get() : this)), 1.0f);
        }
        this.discard();
    }

    public SoundSource getSoundSource() {
        return this.isTamed() ? SoundSource.NEUTRAL : SoundSource.HOSTILE;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("Tamed", this.isTamed());
        compound.putInt("ExplodeTick", this.explodeTick);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setTamed(compound.getBoolean("Collected") || compound.getBoolean("Tamed"));
        if (compound.contains("ExplodeTick")) {
            this.explodeTick = compound.getInt("ExplodeTick");
        }
    }
}

