/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class CreeperMinion
extends ShoulderRidingEntity {
    private static final EntityDataAccessor<Byte> CREEPER_MINION_FLAGS = SynchedEntityData.defineId(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> EXPLODE_STATE = SynchedEntityData.defineId(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> EXPLOSION_RADIUS = SynchedEntityData.defineId(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final int TOTAL_FUSE_TIME = 26;
    private int lastActiveTime;
    private int timeSinceIgnited;

    public CreeperMinion(EntityType<? extends CreeperMinion> entityType, Level level) {
        super(entityType, level);
        this.setDestroyBlocks(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new CreeperMinionSwellGoal());
        this.goalSelector.addGoal(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal<Animal>((PathfinderMob)this, Animal.class, 6.0f, 1.0, 1.2, EntityUtil::isFeline){

            public boolean canUse() {
                return !CreeperMinion.this.isTame() && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new CreeperMinionFollowOwnerGoal());
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LandOnOwnersShoulderGoal(this){

            public boolean canUse() {
                return CreeperMinion.this.isTame() && CreeperMinion.this.getOwner() instanceof Player && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new OwnerTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, null));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CreeperMinion.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CREEPER_MINION_FLAGS, (Object)0);
        builder.define(EXPLODE_STATE, (Object)-1);
        builder.define(EXPLOSION_RADIUS, (Object)Float.valueOf(2.0f));
    }

    @Nullable
    public LivingEntity getOwner() {
        LivingEntity livingEntity;
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            return null;
        }
        Player entity = this.level().getPlayerByUUID(uuid);
        if (entity == null && this.level() instanceof ServerLevel) {
            entity = ((ServerLevel)this.level()).getEntity(uuid);
        }
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    public int getExplodeState() {
        return (Integer)this.entityData.get(EXPLODE_STATE);
    }

    public void setExplodeState(int state) {
        this.entityData.set(EXPLODE_STATE, (Object)state);
    }

    public boolean isCharged() {
        return ((Byte)this.entityData.get(CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setCharged(boolean charged) {
        byte b0 = (Byte)this.entityData.get(CREEPER_MINION_FLAGS);
        this.entityData.set(CREEPER_MINION_FLAGS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.entityData.get(CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.entityData.get(CREEPER_MINION_FLAGS);
        this.entityData.set(CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.entityData.get(CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.entityData.get(CREEPER_MINION_FLAGS);
        this.entityData.set(CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.entityData.get(CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.entityData.get(CREEPER_MINION_FLAGS);
        this.entityData.set(CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.entityData.get(CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.entityData.get(CREEPER_MINION_FLAGS);
        this.entityData.set(CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.entityData.get(EXPLOSION_RADIUS)).floatValue();
    }

    public void setExplosionRadius(float radius) {
        this.entityData.set(EXPLOSION_RADIUS, (Object)Float.valueOf(radius));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_FLAGS_ID.equals(key)) {
            this.refreshDimensions();
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isInSittingPose() ? super.getDefaultDimensions(pose).scale(1.0f, 0.75f) : super.getDefaultDimensions(pose);
    }

    public boolean isBaby() {
        return false;
    }

    public boolean canSitOnShoulder() {
        return super.canSitOnShoulder() && this.canRideOnShoulder() && this.getTarget() == null && this.getExplodeState() <= 0;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        super.thunderHit(level, lightning);
        this.setCharged(true);
    }

    protected boolean shouldDespawnInPeaceful() {
        return !this.isTame();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        boolean hasFallen = super.causeFallDamage(distance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > 21) {
            this.timeSinceIgnited = 21;
        }
        return hasFallen;
    }

    public void tick() {
        if (this.isAlive()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.playSound((SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_PRIMED_SOUND_EVENT.value(), 1.0f, this.getVoicePitch());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 26) {
                this.timeSinceIgnited = 0;
                if (!this.level().isClientSide) {
                    float sizeIn = this.getExplosionRadius() + (this.isCharged() ? 2.0f : 0.0f);
                    Level.ExplosionInteraction interaction = this.canDestroyBlocks() ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                    MutatedExplosionHelper.explode((Entity)this, sizeIn, false, interaction);
                    if (!this.canExplodeContinuously()) {
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
                            this.getOwner().sendSystemMessage((Component)Component.translatable((String)"death.attack.explosion", (Object[])new Object[]{this.getDisplayName()}));
                        }
                        this.dead = true;
                        this.discard();
                        EntityUtil.spawnLingeringCloud((LivingEntity)this);
                    }
                }
                this.setExplodeState(-26);
            }
            if (this.getDeltaMovement().lengthSqr() > (double)0.8f && this.getTarget() != null && this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.5).intersects(this.getTarget().getBoundingBox())) {
                this.timeSinceIgnited = 26;
            }
        }
        super.tick();
    }

    public float getFlashIntensity(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / 24.0f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (this.isTame()) {
            if (itemInHand.is((Item)ModItems.CREEPER_MINION_TRACKER_ITEM.value())) {
                if (this.level().isClientSide) {
                    Proxy.INSTANCE.displayCreeperMinionTrackerGUI(this);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isOwnedBy((LivingEntity)player)) {
                if (itemInHand.is(Items.GUNPOWDER)) {
                    if (this.getHealth() < this.getMaxHealth()) {
                        this.heal(1.0f);
                        itemInHand.shrink(1);
                        double d0 = this.random.nextGaussian() * 0.02;
                        double d1 = this.random.nextGaussian() * 0.02;
                        double d2 = this.random.nextGaussian() * 0.02;
                        this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                    }
                    if (this.getMaxHealth() < 20.0f) {
                        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(this.getMaxHealth() + 1.0f));
                        itemInHand.shrink(1);
                        double d0 = this.random.nextGaussian() * 0.02;
                        double d1 = this.random.nextGaussian() * 0.02;
                        double d2 = this.random.nextGaussian() * 0.02;
                        this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                    }
                } else {
                    if (!itemInHand.is(Items.TNT)) {
                        if (!this.level().isClientSide) {
                            this.setOrderedToSit(!this.isOrderedToSit());
                            this.setLastHurtByMob(null);
                            this.setTarget(null);
                        }
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                    }
                    if (!this.canExplodeContinuously()) {
                        this.forcedAgeTimer += 15;
                        this.setCanExplodeContinuously(true);
                        itemInHand.shrink(1);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                    }
                    float explosionRadius = this.getExplosionRadius();
                    if (explosionRadius < 4.0f) {
                        this.forcedAgeTimer += 10;
                        this.setExplosionRadius(explosionRadius + 0.11f);
                        itemInHand.shrink(1);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                    }
                }
            }
            return InteractionResult.PASS;
        }
        if (itemInHand.is(ItemTags.CREEPER_IGNITERS) && !this.hasIgnited()) {
            player.awardStat(Stats.ITEM_USED.get((Object)itemInHand.getItem()));
            this.level().playSound(player, this.getX(), this.getY(), this.getZ(), SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide) {
                this.ignite();
                if (!itemInHand.isDamageableItem()) {
                    itemInHand.shrink(1);
                } else {
                    ItemHelper.hurtAndBreak((ItemStack)itemInHand, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.isCreative() && itemInHand.is((Item)ModItems.CREEPER_MINION_TRACKER_ITEM.value()) && this.getOwner() == null) {
            if (!this.level().isClientSide) {
                this.setTame(true, true);
                this.setOwnerUUID(player.getUUID());
                player.sendSystemMessage((Component)Component.translatable((String)(((Item)ModItems.CREEPER_MINION_TRACKER_ITEM.value()).getDescriptionId() + ".tame_success"), (Object[])new Object[]{this.getDisplayName(), player.getDisplayName()}));
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity(target, owner, true);
    }

    public boolean doHurtTarget(Entity target) {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            if (this.isTame()) {
                return false;
            }
            if (amount >= 2.0f) {
                amount = 2.0f;
            }
        }
        this.setOrderedToSit(false);
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return this.isTame();
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && this.isTame();
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return super.canAttackType(entityType) && entityType != ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.value();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.72f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.2f));
    }

    @Nullable
    public PlayerTeam getTeam() {
        LivingEntity owner = this.getOwner();
        return owner != null ? owner.getTeam() : super.getTeam();
    }

    public boolean isAlliedTo(Entity entity) {
        LivingEntity owner = this.getOwner();
        return owner != null && (entity == owner || owner.isAlliedTo(entity)) || super.isAlliedTo(entity);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void playAmbientSound() {
        if (this.getTarget() == null && this.getExplodeState() <= 0) {
            super.playAmbientSound();
        }
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_DEATH_SOUND_EVENT.value();
    }

    public SoundSource getSoundSource() {
        return this.isTame() ? SoundSource.NEUTRAL : SoundSource.HOSTILE;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Tamed", this.isTame());
        compound.putBoolean("ExplodesContinuously", this.canExplodeContinuously());
        compound.putBoolean("DestroysBlocks", this.canDestroyBlocks());
        compound.putBoolean("CanRideOnShoulder", this.canRideOnShoulder());
        compound.putBoolean("Ignited", this.hasIgnited());
        compound.putFloat("ExplosionRadius", this.getExplosionRadius());
        if (this.isCharged()) {
            compound.putBoolean("Powered", true);
        }
        for (String s : new String[]{"Age", "ForcedAge", "InLove", "LoveCause"}) {
            compound.remove(s);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTame(compound.getBoolean("Tamed"), false);
        this.setCanExplodeContinuously(compound.getBoolean("ExplodesContinuously"));
        this.setDestroyBlocks(compound.getBoolean("DestroysBlocks"));
        this.setCanRideOnShoulder(compound.getBoolean("CanRideOnShoulder"));
        this.setCharged(compound.getBoolean("Powered"));
        if (compound.contains("ExplosionRadius")) {
            this.setExplosionRadius(compound.getFloat("ExplosionRadius"));
        }
        if (compound.getBoolean("Ignited")) {
            this.ignite();
        }
    }

    class CreeperMinionSwellGoal
    extends Goal {
        public CreeperMinionSwellGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity livingentity = CreeperMinion.this.getTarget();
            return !CreeperMinion.this.isOrderedToSit() && (CreeperMinion.this.getExplodeState() > 0 || livingentity != null && CreeperMinion.this.distanceToSqr((Entity)livingentity) < 9.0 && CreeperMinion.this.hasLineOfSight((Entity)livingentity));
        }

        public void tick() {
            CreeperMinion.this.setExplodeState(CreeperMinion.this.getTarget() != null && !(CreeperMinion.this.distanceToSqr((Entity)CreeperMinion.this.getTarget()) > 36.0) && CreeperMinion.this.getSensing().hasLineOfSight((Entity)CreeperMinion.this.getTarget()) ? 1 : -1);
        }

        public void start() {
            CreeperMinion.this.getNavigation().stop();
        }
    }

    class CreeperMinionFollowOwnerGoal
    extends FollowOwnerGoal {
        public CreeperMinionFollowOwnerGoal() {
            super((TamableAnimal)CreeperMinion.this, 1.2, 10.0f, 5.0f);
        }

        public void tick() {
            if (!CreeperMinion.this.isTame()) {
                if (CreeperMinion.this.getOwner() != null) {
                    CreeperMinion.this.getNavigation().moveTo((Entity)CreeperMinion.this.getOwner(), 1.2);
                }
            } else {
                super.tick();
            }
        }
    }
}

