/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class ServerConfig
implements ConfigCore {
    @Config(description={"Maximum distance the endersoul hand can be used to travel to."})
    @Config.IntRange(min=0, max=512)
    public int endersoulHandTeleportDistance = 256;
    @Config(name="mutant_x_conversions", description={"When infested with a Mutant X potion, what mutant mob should the target transform into. Otherwise the target will ony explode and take damage.", "Format for every entry is \"<namespace>:<path>,<namespace>:<path>\" with the second id representing the mutant. Namespace may be omitted to use \"minecraft\" by default."})
    List<String> mutantXConversionsRaw = Lists.newArrayList((Object[])new String[]{"minecraft:creeper,mutantmonsters:mutant_creeper", "minecraft:enderman,mutantmonsters:mutant_enderman", "minecraft:skeleton,mutantmonsters:mutant_skeleton", "minecraft:snow_golem,mutantmonsters:mutant_snow_golem", "minecraft:zombie,mutantmonsters:mutant_zombie", "minecraft:pig,mutantmonsters:spider_pig"});
    public Map<EntityType<?>, EntityType<?>> mutantXConversions;

    public void afterConfigReload() {
        ConfigDataSet configDataSet = ConfigDataSet.from((ResourceKey)Registries.ENTITY_TYPE, this.mutantXConversionsRaw, (integer, o) -> true, (Class[])new Class[]{String.class});
        record MutantXConversion(EntityType<?> entityType, @Nullable ResourceLocation convertsTo) {
            public boolean isValid() {
                if (this.convertsTo != null && BuiltInRegistries.ENTITY_TYPE.containsKey(this.convertsTo)) {
                    return true;
                }
                MutantMonsters.LOGGER.warn("Unable to parse mutated variant for entry {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType));
                return false;
            }

            public EntityType<?> convertsToType() {
                return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.convertsTo);
            }
        }
        this.mutantXConversions = (Map)configDataSet.toMap().entrySet().stream().map(data -> new MutantXConversion((EntityType)data.getKey(), ResourceLocation.tryParse((String)((String)((Object[])data.getValue())[0])))).filter(MutantXConversion::isValid).collect(ImmutableMap.toImmutableMap(MutantXConversion::entityType, MutantXConversion::convertsToType));
    }
}

