/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantCreeperModel;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.CreeperChargeLayer;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MutantCreeperRenderer
extends AlternateMobRenderer<MutantCreeper, MutantCreeperModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_creeper.png");

    public MutantCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, new MutantCreeperModel(context.bakeLayer(ClientModRegistry.MUTANT_CREEPER)), 1.5f);
        this.addLayer(new CreeperChargeLayer(this, new MutantCreeperModel(context.bakeLayer(ClientModRegistry.MUTANT_CREEPER_ARMOR))));
    }

    protected float getFlipDegrees(MutantCreeper mutantCreeper) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(MutantCreeper mutantCreeper, float partialTick) {
        float overlayColor = mutantCreeper.getOverlayColor(partialTick);
        return mutantCreeper.isJumpAttacking() && mutantCreeper.deathTime == 0 ? ((int)(overlayColor * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)overlayColor, (float)0.5f, (float)1.0f)) : overlayColor;
    }

    protected void scale(MutantCreeper mutantCreeper, PoseStack poseStack, float partialTick) {
        float scale = 1.2f;
        this.shadowRadius = 1.5f;
        if (mutantCreeper.deathTime > 0) {
            float f = (float)mutantCreeper.deathTime / 100.0f;
            scale -= f * 0.4f;
            this.shadowRadius -= f * 0.4f;
        }
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(MutantCreeper mutantCreeper) {
        return TEXTURE_LOCATION;
    }
}

