/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.EndersoulFragmentModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;

public class EndersoulFragmentRenderer
extends EntityRenderer<EndersoulFragment> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/endersoul_fragment.png");
    private final EndersoulFragmentModel model;

    public EndersoulFragmentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EndersoulFragmentModel(context.bakeLayer(ClientModRegistry.ENDERSOUL_FRAGMENT));
        this.shadowRadius = 0.3f;
        this.shadowStrength = 0.5f;
    }

    public void render(EndersoulFragment endersoulFragment, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((Entity)endersoulFragment, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        poseStack.pushPose();
        poseStack.translate(0.0, -1.9, 0.0);
        poseStack.scale(1.6f, 1.6f, 1.6f);
        float ageInTicks = (float)endersoulFragment.tickCount + partialTick;
        this.model.setupAnim(endersoulFragment, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(MutantRenderTypes.energySwirl(TEXTURE_LOCATION, ageInTicks * 0.008f, ageInTicks * 0.008f));
        int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)0.9f, (float)0.3f, (float)1.0f);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(EndersoulFragment endersoulFragment) {
        return TEXTURE_LOCATION;
    }
}

