/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantSnowGolemModel
extends EntityModel<MutantSnowGolem> {
    private final List<ModelPart> parts;
    private final ModelPart pelvis;
    private final ModelPart abdomen;
    private final ModelPart chest;
    private final ModelPart head;
    private final ModelPart innerHead;
    private final ModelPart arm1;
    private final ModelPart innerArm1;
    private final ModelPart arm2;
    private final ModelPart innerArm2;
    private final ModelPart foreArm1;
    private final ModelPart innerForeArm1;
    private final ModelPart foreArm2;
    private final ModelPart innerForeArm2;
    private final ModelPart leg1;
    private final ModelPart innerLeg1;
    private final ModelPart leg2;
    private final ModelPart innerLeg2;
    private final ModelPart foreLeg1;
    private final ModelPart innerForeLeg1;
    private final ModelPart foreLeg2;
    private final ModelPart innerForeLeg2;
    private float partialTick;

    public MutantSnowGolemModel(ModelPart modelPart) {
        this.parts = (List)modelPart.getAllParts().collect(ImmutableList.toImmutableList());
        this.pelvis = modelPart.getChild("pelvis");
        this.abdomen = this.pelvis.getChild("abdomen");
        this.chest = this.abdomen.getChild("chest");
        this.head = this.chest.getChild("head");
        this.innerHead = this.head.getChild("inner_head");
        this.arm1 = this.chest.getChild("arm1");
        this.innerArm1 = this.arm1.getChild("inner_arm1");
        this.arm2 = this.chest.getChild("arm2");
        this.innerArm2 = this.arm2.getChild("inner_arm2");
        this.foreArm1 = this.innerArm1.getChild("fore_arm1");
        this.innerForeArm1 = this.foreArm1.getChild("inner_fore_arm1");
        this.foreArm2 = this.innerArm2.getChild("fore_arm2");
        this.innerForeArm2 = this.foreArm2.getChild("inner_fore_arm2");
        this.leg1 = this.pelvis.getChild("leg1");
        this.innerLeg1 = this.leg1.getChild("inner_leg1");
        this.leg2 = this.pelvis.getChild("leg2");
        this.innerLeg2 = this.leg2.getChild("inner_leg2");
        this.foreLeg1 = this.innerLeg1.getChild("fore_leg1");
        this.innerForeLeg1 = this.foreLeg1.getChild("inner_fore_leg1");
        this.foreLeg2 = this.innerLeg2.getChild("fore_leg2");
        this.innerForeLeg2 = this.foreLeg2.getChild("inner_fore_leg2");
    }

    public MutantSnowGolemModel setRenderHeadOnly() {
        this.parts.forEach(t -> {
            t.skipDraw = true;
        });
        this.innerHead.skipDraw = false;
        this.head.skipDraw = false;
        return this;
    }

    public static LayerDefinition createBodyLayer(int textureWidth, int textureHeight) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pelvis = root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)13.5f, (float)5.0f));
        PartDefinition abdomen = pelvis.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f), PartPose.ZERO);
        PartDefinition chest = abdomen.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(24, 36).addBox(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 12.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition head = chest.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)-12.0f, (float)-2.0f));
        PartDefinition innerHead = head.addOrReplaceChild("inner_head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        innerHead.addOrReplaceChild("head_core", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(80, 46).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = chest.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(68, 16), PartPose.offset((float)-9.0f, (float)-11.0f, (float)0.0f));
        PartDefinition innerArm1 = arm1.addOrReplaceChild("inner_arm1", CubeListBuilder.create().texOffs(68, 16).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), PartPose.ZERO);
        PartDefinition foreArm1 = innerArm1.addOrReplaceChild("fore_arm1", CubeListBuilder.create().texOffs(96, 0), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm1.addOrReplaceChild("inner_fore_arm1", CubeListBuilder.create().texOffs(96, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.ZERO);
        PartDefinition arm2 = chest.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(68, 16).mirror(), PartPose.offset((float)9.0f, (float)-11.0f, (float)0.0f));
        PartDefinition innerArm2 = arm2.addOrReplaceChild("inner_arm2", CubeListBuilder.create().texOffs(68, 16).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), PartPose.ZERO);
        PartDefinition foreArm2 = innerArm2.addOrReplaceChild("fore_arm2", CubeListBuilder.create().texOffs(96, 0).mirror(), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm2.addOrReplaceChild("inner_fore_arm2", CubeListBuilder.create().texOffs(96, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.ZERO);
        PartDefinition leg1 = pelvis.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(88, 18), PartPose.offset((float)-4.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition innerLeg1 = leg1.addOrReplaceChild("inner_leg1", CubeListBuilder.create().texOffs(88, 18).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.ZERO);
        PartDefinition foreLeg1 = innerLeg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(88, 32), PartPose.offset((float)-1.0f, (float)6.0f, (float)-0.0f));
        foreLeg1.addOrReplaceChild("inner_fore_leg1", CubeListBuilder.create().texOffs(88, 32).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.ZERO);
        PartDefinition leg2 = pelvis.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(88, 18).mirror(), PartPose.offset((float)4.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition innerLeg2 = leg2.addOrReplaceChild("inner_leg2", CubeListBuilder.create().texOffs(88, 18).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.ZERO);
        PartDefinition foreLeg2 = innerLeg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(88, 32).mirror(), PartPose.offset((float)1.0f, (float)6.0f, (float)-0.0f));
        foreLeg2.addOrReplaceChild("inner_fore_leg2", CubeListBuilder.create().texOffs(88, 32).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void copyPropertiesTo(MutantSnowGolemModel otherModel) {
        for (int i = 0; i < this.parts.size(); ++i) {
            otherModel.parts.get(i).copyFrom(this.parts.get(i));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.pelvis.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.y = 13.5f;
        this.abdomen.xRot = 0.1308997f;
        this.chest.xRot = 0.1308997f;
        this.chest.yRot = 0.0f;
        this.head.xRot = -0.2617994f;
        this.innerHead.xRot = 0.0f;
        this.innerHead.yRot = 0.0f;
        this.arm1.xRot = -0.31415927f;
        this.arm1.zRot = 0.0f;
        this.innerArm1.xRot = 0.0f;
        this.innerArm1.yRot = 0.5235988f;
        this.innerArm1.zRot = 0.5235988f;
        this.foreArm1.yRot = -0.5235988f;
        this.foreArm1.zRot = -0.2617994f;
        this.innerForeArm1.xRot = -0.5235988f;
        this.arm2.xRot = -0.31415927f;
        this.arm2.zRot = 0.0f;
        this.innerArm2.xRot = 0.0f;
        this.innerArm2.yRot = -0.5235988f;
        this.innerArm2.zRot = -0.5235988f;
        this.foreArm2.yRot = 0.5235988f;
        this.foreArm2.zRot = 0.2617994f;
        this.innerForeArm2.xRot = -0.5235988f;
        this.leg1.xRot = -0.62831855f;
        this.innerLeg1.zRot = 0.5235988f;
        this.foreLeg1.zRot = -0.5235988f;
        this.innerForeLeg1.xRot = 0.69813174f;
        this.leg2.xRot = -0.62831855f;
        this.innerLeg2.zRot = -0.5235988f;
        this.foreLeg2.zRot = 0.5235988f;
        this.innerForeLeg2.xRot = 0.69813174f;
    }

    private void animate(MutantSnowGolem golem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float temp = 0.5f;
        float walkAnim = Mth.sin((float)(limbSwing * 0.45f)) * limbSwingAmount;
        float walkAnim1 = (Mth.cos((float)((limbSwing - temp) * 0.45f)) + temp) * limbSwingAmount;
        float walkAnim2 = (Mth.cos((float)((limbSwing - temp + (float)Math.PI * 2) * 0.45f)) + temp) * limbSwingAmount;
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.11f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (golem.isThrowing()) {
            this.animateThrow(golem.getThrowingTick());
            float scale = 1.0f - Mth.clamp((float)((float)golem.getThrowingTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim *= scale;
        }
        this.innerHead.xRot -= breatheAnim * 0.01f;
        this.chest.xRot -= breatheAnim * 0.01f;
        this.arm1.zRot += breatheAnim * 0.03f;
        this.arm2.zRot -= breatheAnim * 0.03f;
        this.innerHead.xRot += facePitch;
        this.innerHead.yRot += faceYaw;
        this.pelvis.y += Math.abs(walkAnim) * 1.5f;
        this.abdomen.xRot += limbSwingAmount * 0.2f;
        this.chest.yRot -= walkAnim * 0.1f;
        this.head.xRot -= limbSwingAmount * 0.2f;
        this.arm1.xRot -= walkAnim * 0.6f;
        this.arm2.xRot += walkAnim * 0.6f;
        this.innerForeArm1.xRot -= walkAnim * 0.2f;
        this.innerForeArm2.xRot += walkAnim * 0.2f;
        this.leg1.xRot += walkAnim1 * 1.1f;
        this.leg2.xRot += walkAnim2 * 1.1f;
        this.innerForeLeg1.xRot += walkAnim * 0.2f;
        this.innerForeLeg2.xRot -= walkAnim * 0.2f;
    }

    private void animateThrow(int fullTick) {
        if (fullTick < 7) {
            float tick = ((float)fullTick + this.partialTick) / 7.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += -f * 0.2f;
            this.chest.xRot += -f * 0.4f;
            this.arm1.xRot += -f * 1.6f;
            this.arm1.zRot += f * 0.8f;
            this.arm2.xRot += -f * 1.6f;
            this.arm2.zRot += -f * 0.8f;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 7) + this.partialTick) / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += -f * 0.4f + 0.2f;
            this.chest.xRot += -f * 0.6f + 0.2f;
            this.arm1.xRot += -f * 0.8f - 0.8f;
            this.arm1.zRot += 0.8f;
            this.arm2.xRot += -f * 0.8f - 0.8f;
            this.arm2.zRot += -0.8f;
        } else if (fullTick < 14) {
            this.abdomen.xRot += 0.2f;
            this.chest.xRot += 0.2f;
            this.arm1.xRot += -0.8f;
            this.arm1.zRot += 0.8f;
            this.arm2.xRot += -0.8f;
            this.arm2.zRot += -0.8f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 6.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += f * 0.2f;
            this.chest.xRot += f * 0.2f;
            this.arm1.xRot += -f * 0.8f;
            this.arm1.zRot += f * 0.8f;
            this.arm2.xRot += -f * 0.8f;
            this.arm2.zRot += -f * 0.8f;
        }
    }

    public void prepareMobModel(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    public void translateArm(boolean leftHanded, PoseStack matrixStackIn) {
        this.pelvis.translateAndRotate(matrixStackIn);
        this.abdomen.translateAndRotate(matrixStackIn);
        this.chest.translateAndRotate(matrixStackIn);
        if (leftHanded) {
            this.arm2.translateAndRotate(matrixStackIn);
            this.innerArm2.translateAndRotate(matrixStackIn);
            this.foreArm2.translateAndRotate(matrixStackIn);
            this.innerForeArm2.translateAndRotate(matrixStackIn);
        } else {
            this.arm1.translateAndRotate(matrixStackIn);
            this.innerArm1.translateAndRotate(matrixStackIn);
            this.foreArm1.translateAndRotate(matrixStackIn);
            this.innerForeArm1.translateAndRotate(matrixStackIn);
        }
    }
}

