/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.model.MutantSkeletonModel;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class MutantSkeletonPartModel
extends Model {
    private final List<ModelPart> parts;

    public MutantSkeletonPartModel(ModelPart modelPart, ModelPart spineModelPart) {
        super(RenderType::entityCutoutNoCull);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)modelPart.getChild("pelvis"));
        for (int i = 0; i < 3; ++i) {
            MutantSkeletonModel.Spine spine = new MutantSkeletonModel.Spine(spineModelPart, "");
            spine.setAngles(i == 1);
            for (int j = 0; j < 3; ++j) {
                builder.add((Object[])new ModelPart[]{spine.side1[i], spine.side2[i]});
            }
        }
        ModelPart head = modelPart.getChild("head");
        builder.add((Object)head);
        builder.add((Object)head.getChild("jaw"));
        builder.add((Object)modelPart.getChild("arm1"));
        builder.add((Object)modelPart.getChild("arm2"));
        builder.add((Object)modelPart.getChild("forearm1"));
        builder.add((Object)modelPart.getChild("forearm2"));
        builder.add((Object)modelPart.getChild("leg1"));
        builder.add((Object)modelPart.getChild("leg2"));
        builder.add((Object)modelPart.getChild("foreleg1"));
        builder.add((Object)modelPart.getChild("foreleg2"));
        builder.add((Object)modelPart.getChild("shoulder1"));
        builder.add((Object)modelPart.getChild("shoulder2"));
        this.parts = builder.build();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 6.0f), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.4f)), PartPose.ZERO);
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(72, 0).addBox(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.7f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)3.7f, (float)0.09817477f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("forearm1", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        root.addOrReplaceChild("forearm2", CubeListBuilder.create().texOffs(16, 28).mirror().addBox(-2.0f, -7.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("foreleg1", CubeListBuilder.create().texOffs(32, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("foreleg2", CubeListBuilder.create().texOffs(32, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("shoulder1", CubeListBuilder.create().texOffs(28, 16).addBox(-4.0f, -1.5f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.ZERO);
        root.addOrReplaceChild("shoulder2", CubeListBuilder.create().texOffs(28, 16).mirror().addBox(-4.0f, -1.5f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
    }

    public ModelPart getPart(int index) {
        return this.parts.get(index);
    }
}

