/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantCreeperModel
extends EntityModel<MutantCreeper> {
    private final ModelPart pelvis;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart frleg;
    private final ModelPart flleg;
    private final ModelPart frforeleg;
    private final ModelPart flforeleg;
    private final ModelPart brleg;
    private final ModelPart blleg;
    private final ModelPart brforeleg;
    private final ModelPart blforeleg;

    public MutantCreeperModel(ModelPart modelPart) {
        this.pelvis = modelPart.getChild("pelvis");
        this.body = this.pelvis.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.frleg = this.pelvis.getChild("front_right_leg");
        this.flleg = this.pelvis.getChild("front_left_leg");
        this.frforeleg = this.frleg.getChild("front_right_fore_leg");
        this.flforeleg = this.flleg.getChild("front_left_fore_leg");
        this.brleg = this.pelvis.getChild("back_right_leg");
        this.blleg = this.pelvis.getChild("back_left_leg");
        this.brforeleg = this.brleg.getChild("back_right_fore_leg");
        this.blforeleg = this.blleg.getChild("back_left_fore_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pelvis = root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -14.0f, -4.0f, 10.0f, 14.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)14.0f, (float)-3.0f));
        PartDefinition body = pelvis.addOrReplaceChild("body", CubeListBuilder.create().texOffs(36, 0).addBox(-4.5f, -14.0f, -3.5f, 9.0f, 16.0f, 7.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(68, 0).addBox(-4.0f, -14.0f, -3.0f, 8.0f, 14.0f, 6.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-11.0f, (float)1.0f));
        neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-5.0f, -12.0f, -5.0f, 10.0f, 12.0f, 10.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-12.0f, (float)1.0f));
        PartDefinition frontRightLeg = pelvis.addOrReplaceChild("front_right_leg", CubeListBuilder.create().texOffs(40, 24).addBox(-3.0f, -4.0f, -14.0f, 6.0f, 4.0f, 14.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        frontRightLeg.addOrReplaceChild("front_right_fore_leg", CubeListBuilder.create().texOffs(96, 0).addBox(-3.5f, 0.0f, -4.0f, 7.0f, 20.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-4.0f, (float)-14.0f));
        PartDefinition frontLeftLeg = pelvis.addOrReplaceChild("front_left_leg", CubeListBuilder.create().texOffs(40, 24).mirror().addBox(-3.0f, -4.0f, -14.0f, 6.0f, 4.0f, 14.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        frontLeftLeg.addOrReplaceChild("front_left_fore_leg", CubeListBuilder.create().texOffs(96, 0).mirror().addBox(-3.5f, 0.0f, -4.0f, 7.0f, 20.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-4.0f, (float)-14.0f));
        PartDefinition backRightLeg = pelvis.addOrReplaceChild("back_right_leg", CubeListBuilder.create().texOffs(0, 44).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 14.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)-2.0f, (float)4.0f));
        backRightLeg.addOrReplaceChild("back_right_fore_leg", CubeListBuilder.create().texOffs(80, 28).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-4.0f, (float)14.0f));
        PartDefinition backLeftLeg = pelvis.addOrReplaceChild("back_left_leg", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 14.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)-2.0f, (float)4.0f));
        backLeftLeg.addOrReplaceChild("back_left_fore_leg", CubeListBuilder.create().texOffs(80, 28).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-4.0f, (float)14.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.pelvis.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(MutantCreeper entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.y = 14.0f;
        this.pelvis.xRot = -0.7853982f;
        this.body.xRot = 0.9424778f;
        this.body.yRot = 0.0f;
        this.neck.xRot = 1.0471976f;
        this.head.xRot = 0.5235988f;
        this.frleg.xRot = 0.31415927f;
        this.frleg.yRot = -0.7853982f;
        this.frleg.zRot = 0.0f;
        this.flleg.xRot = 0.31415927f;
        this.flleg.yRot = 0.7853982f;
        this.flleg.zRot = 0.0f;
        this.frforeleg.xRot = -0.20943952f;
        this.frforeleg.yRot = 0.3926991f;
        this.flforeleg.xRot = -0.20943952f;
        this.flforeleg.yRot = -0.3926991f;
        this.brleg.xRot = 0.9f;
        this.brleg.yRot = 0.62831855f;
        this.brleg.zRot = 0.0f;
        this.blleg.xRot = 0.9f;
        this.blleg.yRot = -0.62831855f;
        this.blleg.zRot = 0.0f;
        this.brforeleg.xRot = 0.48332196f;
        this.blforeleg.xRot = 0.48332196f;
    }

    private void animate(MutantCreeper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.1f));
        float walkAnim1 = (Mth.sin((float)(limbSwing * (float)Math.PI / 4.0f)) + 0.4f) * limbSwingAmount;
        float walkAnim2 = (Mth.sin((float)(limbSwing * (float)Math.PI / 4.0f + (float)Math.PI)) + 0.4f) * limbSwingAmount;
        if (walkAnim1 < 0.0f) {
            walkAnim1 = 0.0f;
        }
        if (walkAnim2 < 0.0f) {
            walkAnim2 = 0.0f;
        }
        float walkAnim3 = Mth.sin((float)(limbSwing * (float)Math.PI / 8.0f)) * limbSwingAmount;
        float walkAnim4 = (Mth.sin((float)(limbSwing * (float)Math.PI / 4.0f + 1.5707964f)) + 0.4f) * limbSwingAmount;
        float walkAnim5 = (Mth.sin((float)(limbSwing * (float)Math.PI / 4.0f + 4.712389f)) + 0.4f) * limbSwingAmount;
        if (walkAnim4 < 0.0f) {
            walkAnim4 = 0.0f;
        }
        if (walkAnim5 < 0.0f) {
            walkAnim5 = 0.0f;
        }
        float walkAnim6 = Mth.sin((float)(limbSwing * (float)Math.PI / 8.0f + 1.5707964f)) * limbSwingAmount;
        float faceYaw = netHeadYaw / 57.295776f;
        float facePitch = headPitch / 57.295776f;
        float f6 = faceYaw / 3.0f;
        float f7 = facePitch / 3.0f;
        this.pelvis.y += Mth.sin((float)(limbSwing * (float)Math.PI / 4.0f)) * limbSwingAmount * 0.5f;
        this.body.xRot += breatheAnim * 0.02f;
        this.body.xRot += f7;
        this.body.yRot += f6;
        this.neck.xRot += breatheAnim * 0.02f;
        this.neck.xRot += f7;
        this.neck.yRot = f6;
        this.head.xRot += breatheAnim * 0.02f;
        this.head.xRot += f7;
        this.head.yRot = f6;
        this.frleg.xRot -= walkAnim1 * 0.3f;
        this.frleg.yRot += walkAnim3 * 0.2f;
        this.frleg.zRot += walkAnim3 * 0.2f;
        this.flleg.xRot -= walkAnim2 * 0.3f;
        this.flleg.yRot -= walkAnim3 * 0.2f;
        this.flleg.zRot -= walkAnim3 * 0.2f;
        this.brleg.xRot += walkAnim5 * 0.3f;
        this.brleg.yRot -= walkAnim6 * 0.2f;
        this.brleg.zRot -= walkAnim6 * 0.2f;
        this.blleg.xRot += walkAnim4 * 0.3f;
        this.blleg.yRot += walkAnim6 * 0.2f;
        this.blleg.zRot += walkAnim6 * 0.2f;
        if (this.attackTime > 0.0f) {
            float swingAnim = Mth.sin((float)(this.attackTime * (float)Math.PI));
            this.body.xRot += swingAnim * (float)Math.PI / 3.0f;
            this.neck.xRot -= swingAnim * (float)Math.PI / 4.0f;
        }
    }
}

