/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class EndersoulFragmentModel
extends EntityModel<EndersoulFragment> {
    private final ModelPart base;
    private final ModelPart[] sticks = new ModelPart[8];

    public EndersoulFragmentModel(ModelPart root) {
        this.base = root.getChild("base");
        for (int i = 0; i < this.sticks.length; ++i) {
            this.sticks[i] = this.base.getChild("stick" + i);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition base = root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        for (int i = 0; i < 8; ++i) {
            CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(0, 0);
            if (i < 4) {
                cubeListBuilder.addBox(-0.5f, -4.0f, -0.5f, 1.0f, 8.0f, 1.0f);
            } else {
                cubeListBuilder.addBox(-0.5f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.15f));
            }
            base.addOrReplaceChild("stick" + i, cubeListBuilder, PartPose.ZERO);
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.base.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(EndersoulFragment entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.sticks.length; ++i) {
            this.sticks[i].xRot = entityIn.stickRotations[i][0];
            this.sticks[i].yRot = entityIn.stickRotations[i][1];
            this.sticks[i].zRot = entityIn.stickRotations[i][2];
        }
    }
}

