/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CreeperMinionModel
extends HierarchicalModel<CreeperMinion> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public CreeperMinionModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)18.0f, (float)4.0f));
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)18.0f, (float)4.0f));
        root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)18.0f, (float)-4.0f));
        root.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)18.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.leg4);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5625f, 0.0f);
        this.headParts().forEach(modelPart -> modelPart.render(poseStack, buffer, packedLight, packedOverlay, color));
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 1.5f, 0.0f);
        this.bodyParts().forEach(modelPart -> modelPart.render(poseStack, buffer, packedLight, packedOverlay, color));
        poseStack.popPose();
    }

    public void setupAnim(CreeperMinion entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnim(entity.isInSittingPose(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void setupAnim(boolean isInSittingPose, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leg1.xRot = Mth.cos((float)((limbSwing *= 3.0f) * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.head.y = 6.0f;
        this.body.y = 6.0f;
        this.leg1.setPos(-2.0f, 18.0f, 4.0f);
        this.leg2.setPos(2.0f, 18.0f, 4.0f);
        this.leg3.setPos(-2.0f, 18.0f, -4.0f);
        this.leg4.setPos(2.0f, 18.0f, -4.0f);
        if (isInSittingPose) {
            this.head.y += 3.0f;
            this.body.y += 6.0f;
            this.leg1.y += 4.0f;
            this.leg1.z -= 2.0f;
            this.leg2.y += 4.0f;
            this.leg2.z -= 2.0f;
            this.leg3.y += 4.0f;
            this.leg3.z += 2.0f;
            this.leg4.y += 4.0f;
            this.leg4.z += 2.0f;
            this.leg1.xRot = 1.5707964f;
            this.leg2.xRot = 1.5707964f;
            this.leg3.xRot = -1.5707964f;
            this.leg4.xRot = -1.5707964f;
        }
    }
}

