/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.api.client.searchtree.v1.SearchRegistryHelper;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class S2CBuildOffersMessage
implements MessageV2<S2CBuildOffersMessage> {
    private int containerId;
    private Int2IntOpenHashMap idToOfferCount;

    public S2CBuildOffersMessage() {
    }

    public S2CBuildOffersMessage(int containerId, Int2IntOpenHashMap idToOfferCount) {
        this.containerId = containerId;
        this.idToOfferCount = idToOfferCount;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId);
        buf.writeVarInt(this.idToOfferCount.size());
        for (Int2IntMap.Entry entry : this.idToOfferCount.int2IntEntrySet()) {
            buf.writeInt(entry.getIntKey());
            buf.writeVarInt(entry.getIntValue());
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readVarInt();
        Int2IntOpenHashMap idToOfferCount = new Int2IntOpenHashMap();
        int length = buf.readVarInt();
        for (int i = 0; i < length; ++i) {
            idToOfferCount.put(buf.readInt(), buf.readVarInt());
        }
        this.idToOfferCount = idToOfferCount;
    }

    public MessageV2.MessageHandler<S2CBuildOffersMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CBuildOffersMessage>(this){

            public void handle(S2CBuildOffersMessage message, Player player, Object gameInstance) {
                AbstractContainerMenu abstractContainerMenu;
                Minecraft minecraft = (Minecraft)gameInstance;
                if (message.containerId == player.containerMenu.containerId && (abstractContainerMenu = player.containerMenu) instanceof TradingPostMenu) {
                    TradingPostMenu playerMenu = (TradingPostMenu)abstractContainerMenu;
                    abstractContainerMenu = minecraft.screen;
                    if (abstractContainerMenu instanceof TradingPostScreen) {
                        TradingPostScreen screen = (TradingPostScreen)abstractContainerMenu;
                        playerMenu.getTraders().buildOffers(message.idToOfferCount);
                        SearchRegistryHelper.populateSearchTree(TradingPostClient.MERCHANT_OFFERS_SEARCH_TREE, (List)playerMenu.getOffers());
                        screen.refreshSearchResults();
                    }
                }
            }
        };
    }
}

