/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.data.InfectionData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinAi.class})
public abstract class MixinPiglinAi {
    @Inject(at={@At(value="HEAD")}, method={"isNearZombified(Lnet/minecraft/world/entity/monster/piglin/Piglin;)Z"}, cancellable=true)
    private static void hordes$isNearZombified(Piglin piglin, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isZombified"}, cancellable=true)
    private static void hordes$isZombified(EntityType<?> type, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && InfectionData.INSTANCE.canCauseInfection(type)) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"findNearestValidAttackTarget"}, cancellable=true)
    private static void hordes$findNearestValidAttackTarget(Piglin piglin, CallbackInfoReturnable<Optional<? extends LivingEntity>> callback) {
        if (!((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() || ((Optional)callback.getReturnValue()).isPresent()) {
            return;
        }
        ItemStack stack = piglin.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!stack.is(Items.CROSSBOW)) {
            return;
        }
        Brain brain = piglin.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED)) {
            callback.setReturnValue((Object)brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"admireGoldItem"}, cancellable=true)
    private static void hordes$admireGoldItem(LivingEntity entity, CallbackInfo callback) {
        if (entity.hasEffect(HordesInfection.INFECTED) && entity.getOffhandItem().is(HordesInfection.INFECTION_CURES_TAG)) {
            entity.startUsingItem(InteractionHand.OFF_HAND);
        }
    }
}

