/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.NetworkMessage;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.infection.client.InfectionClientHandler;

public class CureEntityMessage
implements NetworkMessage {
    public static CustomPacketPayload.Type<CureEntityMessage> TYPE = new CustomPacketPayload.Type(Constants.loc("cure_entity"));
    private int entity;

    public CureEntityMessage() {
    }

    public CureEntityMessage(LivingEntity entity) {
        this.entity = entity.getId();
    }

    public void read(FriendlyByteBuf buf) {
        this.entity = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entity);
    }

    public LivingEntity getEntity(Level level) {
        return (LivingEntity)level.getEntity(this.entity);
    }

    public void process(IPayloadContext ctx) {
        if (ctx.connection().getDirection().isClientbound()) {
            ctx.enqueueWork(() -> InfectionClientHandler.INSTANCE.processCureEntity(this));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

