/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.InfectEntityEvent;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectedEffect;
import net.smileycorp.hordes.infection.data.InfectionConversionEntry;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;
import net.smileycorp.hordes.infection.network.SyncImmunityItemsMessage;
import net.smileycorp.hordes.infection.network.SyncWearableProtectionMessage;

public class InfectionData
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static InfectionData INSTANCE = new InfectionData();
    private final Map<EntityType<?>, InfectionConversionEntry> conversionTable = Maps.newHashMap();
    private final Map<Item, Integer> immunityItems = Maps.newHashMap();
    private final Map<Item, Float> wearablesProtection = Maps.newHashMap();
    private final Map<EntityType<?>, Float> entityInfectChance = Maps.newHashMap();

    public InfectionData() {
        super(GSON, "infection");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        Item item;
        ResourceLocation name;
        JsonObject obj;
        JsonElement json;
        ResourceLocation loc;
        this.conversionTable.clear();
        HordesLogger.logInfo("Loading conversion tables");
        for (String id : manager.getNamespaces()) {
            loc = ResourceLocation.tryBuild((String)id, (String)"infection_conversions");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading conversion table " + String.valueOf(loc));
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        InfectionConversionEntry entry = InfectionConversionEntry.deserialize(element.getAsJsonObject());
                        this.conversionTable.put(entry.getEntity(), entry);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load conversion entry " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load conversion table " + String.valueOf(loc), e);
            }
        }
        this.immunityItems.clear();
        HordesLogger.logInfo("Loading immunity item list");
        for (String id : manager.getNamespaces()) {
            loc = ResourceLocation.tryBuild((String)id, (String)"immunity_items");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading immunity item list " + String.valueOf(loc));
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        obj = element.getAsJsonObject();
                        name = ResourceLocation.tryParse((String)obj.get("item").getAsString());
                        item = (Item)BuiltInRegistries.ITEM.get(name);
                        int duration = obj.get("duration").getAsInt();
                        this.immunityItems.put(item, duration);
                        HordesLogger.logInfo("Loaded immunity item " + String.valueOf(name) + " with duration " + duration);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load immunity item " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load immunity item list " + String.valueOf(loc), e);
            }
        }
        this.wearablesProtection.clear();
        HordesLogger.logInfo("Loading wearables protection list");
        for (String id : manager.getNamespaces()) {
            loc = ResourceLocation.tryBuild((String)id, (String)"wearables_protection");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading wearables protection list " + String.valueOf(loc));
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        obj = element.getAsJsonObject();
                        name = ResourceLocation.tryParse((String)obj.get("item").getAsString());
                        item = (Item)BuiltInRegistries.ITEM.get(name);
                        float modifier = obj.get("protection").getAsFloat();
                        if (item == null || item == Items.AIR) {
                            throw new NullPointerException();
                        }
                        this.wearablesProtection.put(item, Float.valueOf(modifier));
                        HordesLogger.logInfo("Loaded wearable protection " + String.valueOf(name) + " with modifier " + modifier);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load wearable protection " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load wearable protection list " + String.valueOf(loc), e);
            }
        }
        this.entityInfectChance.clear();
        HordesLogger.logInfo("Loading entity infection chances.");
        for (String id : manager.getNamespaces()) {
            loc = ResourceLocation.tryBuild((String)id, (String)"infection_entities");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading entity infection list " + String.valueOf(loc));
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        obj = element.getAsJsonObject();
                        name = ResourceLocation.tryParse((String)obj.get("entity").getAsString());
                        EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(name);
                        float chance = obj.get("chance").getAsFloat();
                        this.entityInfectChance.put(entity, Float.valueOf(chance));
                        HordesLogger.logInfo("Loaded infection entity " + String.valueOf(name) + " with infect chance " + chance);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to infection entity " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load entity infection list " + String.valueOf(loc), e);
            }
        }
    }

    public void tryToInfect(LivingEntity entity, LivingEntity attacker, DamageSource source, float amount) {
        InfectionConversionEntry entry;
        if (((InfectEntityEvent)NeoForge.EVENT_BUS.post((Event)new InfectEntityEvent(entity, attacker, source, amount))).isCanceled()) {
            return;
        }
        if (entity instanceof Player && ((Boolean)InfectionConfig.infectPlayers.get()).booleanValue() && entity.getRandom().nextFloat() <= this.getInfectionChance(entity, attacker)) {
            InfectedEffect.apply(entity);
        }
        if ((entry = this.conversionTable.get(entity.getType())) != null && entry.shouldInfect(entity, attacker)) {
            InfectedEffect.apply(entity);
        }
    }

    public boolean infectedTarget(Entity entity) {
        return !(entity instanceof Player) && this.canBeInfected(entity);
    }

    public boolean canBeInfected(Entity entity) {
        if (entity instanceof Player) {
            return (Boolean)InfectionConfig.infectPlayers.get();
        }
        if (!(entity instanceof Mob)) {
            return false;
        }
        return this.conversionTable.containsKey(entity.getType());
    }

    public boolean convertEntity(Mob entity) {
        InfectionConversionEntry entry = this.conversionTable.get(entity.getType());
        if (entry != null) {
            return entry.convertEntity(entity) != null;
        }
        return false;
    }

    public int getImmunityLength(ItemStack stack) {
        return this.immunityItems.getOrDefault(stack.getItem(), 0);
    }

    public boolean applyImmunity(LivingEntity entity, Item item) {
        if (!this.immunityItems.containsKey(item)) {
            return false;
        }
        entity.addEffect(new MobEffectInstance(HordesInfection.IMMUNITY, this.immunityItems.get(item) * 20));
        return true;
    }

    public float getInfectionChance(EntityType<?> entity) {
        return this.entityInfectChance.containsKey(entity) ? this.entityInfectChance.get(entity).floatValue() : 0.0f;
    }

    public float getInfectionChance(LivingEntity entity, LivingEntity attacker) {
        return (float)attacker.getAttributeValue(HordesInfection.INFECTIVITY) * (1.0f - (float)entity.getAttributeValue(HordesInfection.INFECTION_RESISTANCE));
    }

    public float getProtection(EntityType<?> type) {
        return type == EntityType.PLAYER ? (float)((Double)InfectionConfig.playerInfectionResistance.get()).doubleValue() : (this.conversionTable.containsKey(type) ? this.conversionTable.get(type).protection : 0.0f);
    }

    public float getProtectionMultiplier(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0.0f;
        }
        Item item = stack.getItem();
        return this.wearablesProtection.containsKey(item) ? this.wearablesProtection.get(item).floatValue() : 0.0f;
    }

    public boolean canCauseInfection(EntityType<?> entity) {
        return this.entityInfectChance.containsKey(entity);
    }

    public boolean hasInfectGoal(Entity entity) {
        return entity instanceof LivingEntity && this.entityInfectChance.containsKey(entity.getType());
    }

    public boolean canCauseInfection(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (!((LivingEntity)entity).getAttributes().hasAttribute(HordesInfection.INFECTIVITY)) {
            return false;
        }
        return ((LivingEntity)entity).getAttribute(HordesInfection.INFECTIVITY).getValue() > 0.0;
    }

    public void syncData(ServerPlayer player) {
        InfectionPacketHandler.sendTo((CustomPacketPayload)new SyncImmunityItemsMessage(this.immunityItems), player);
        InfectionPacketHandler.sendTo((CustomPacketPayload)new SyncWearableProtectionMessage(this.wearablesProtection), player);
    }

    public void readImmunityItems(List<Map.Entry<Item, Integer>> data) {
        this.immunityItems.clear();
        data.forEach(e -> this.immunityItems.put((Item)e.getKey(), (Integer)e.getValue()));
    }

    public void readWearableProtection(List<Pair<Item, Float>> data) {
        this.wearablesProtection.clear();
        data.forEach(e -> this.wearablesProtection.put((Item)e.getFirst(), (Float)e.getSecond()));
    }

    public void clear() {
        this.immunityItems.clear();
        this.wearablesProtection.clear();
    }
}

