/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.data;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.smileycorp.atlas.api.util.Func;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.mixinutils.VillageMerchant;
import net.smileycorp.hordes.hordeevent.data.DataRegistry;
import net.smileycorp.hordes.infection.data.InfectionData;

public class InfectionConversionEntry {
    protected final EntityType<? extends Mob> entity;
    protected final EntityType<? extends Mob> result;
    protected final float protection;
    protected final CompoundTag nbt;

    private InfectionConversionEntry(EntityType<? extends Mob> entity, EntityType<? extends Mob> result, float protection, CompoundTag nbt) {
        if (entity == null || result == null) {
            throw new NullPointerException();
        }
        this.entity = entity;
        this.result = result;
        this.protection = protection;
        this.nbt = nbt;
        HordesLogger.logInfo("Loaded conversion " + String.valueOf(entity) + " to " + String.valueOf(result) + String.valueOf(nbt != null ? nbt : "") + " with an infection resistance of " + protection);
    }

    public LivingEntity convertEntity(Mob entity) {
        LivingConversionEvent.Pre preEvent = new LivingConversionEvent.Pre((LivingEntity)entity, this.result, xva$0 -> Func.Void((Object[])new Object[]{xva$0}));
        NeoForge.EVENT_BUS.post((Event)preEvent);
        Mob zombie = entity.convertTo(this.result, true);
        if (zombie instanceof AgeableMob) {
            ((AgeableMob)zombie).setAge(entity.isBaby() ? -1000000 : 0);
        }
        if (zombie instanceof Zombie) {
            ((Zombie)zombie).setBaby(entity.isBaby());
        }
        if (this.nbt != null) {
            zombie.readAdditionalSaveData(this.nbt);
        }
        if (entity instanceof VillagerDataHolder && zombie instanceof VillagerDataHolder) {
            ((VillagerDataHolder)zombie).setVillagerData(((VillagerDataHolder)entity).getVillagerData());
        }
        if (entity instanceof VillageMerchant && zombie instanceof VillageMerchant) {
            ((VillageMerchant)zombie).setMerchantGossips(((VillageMerchant)entity).getMerchantGossips());
            ((VillageMerchant)zombie).setMerchantOffers(((VillageMerchant)entity).getMerchantOffers());
            ((VillageMerchant)zombie).setMerchantXp(((VillageMerchant)entity).getMerchantXp());
        }
        if (entity instanceof Zombie) {
            ((Zombie)zombie).finalizeSpawn((ServerLevelAccessor)((ServerLevel)entity.level()), entity.level().getCurrentDifficultyAt(zombie.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
        }
        LivingConversionEvent.Post postEvent = new LivingConversionEvent.Post((LivingEntity)entity, (LivingEntity)zombie);
        NeoForge.EVENT_BUS.post((Event)postEvent);
        return zombie;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public boolean shouldInfect(LivingEntity entity, LivingEntity attacker) {
        if (!InfectionData.INSTANCE.canCauseInfection((Entity)attacker)) {
            return false;
        }
        return entity.getRandom().nextFloat() <= InfectionData.INSTANCE.getInfectionChance(entity, attacker);
    }

    public static InfectionConversionEntry deserialize(JsonObject json) throws Exception {
        EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)json.get("entity").getAsString()));
        EntityType converts_to = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)json.get("converts_to").getAsString()));
        float chance = json.get("protection").getAsFloat();
        CompoundTag nbt = json.has("nbt") ? DataRegistry.parseNBT(entity.toShortString(), json.get("nbt").getAsString()) : null;
        return new InfectionConversionEntry((EntityType<? extends Mob>)entity, (EntityType<? extends Mob>)converts_to, chance, nbt);
    }
}

