/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.capability.Infection;
import net.smileycorp.hordes.infection.network.InfectMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;

public class InfectedEffect
extends MobEffect {
    private final ResourceLocation SPEED_MOD_NAME = Constants.loc("infected");
    private final double SPEED_MOD_AMOUNT = -0.1;

    public InfectedEffect() {
        super(MobEffectCategory.HARMFUL, 0x440002);
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            ((Player)entity).causeFoodExhaustion(0.03f * (float)(amplifier + 1));
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return (Boolean)InfectionConfig.infectHunger.get();
    }

    public void addAttributeModifiers(AttributeMap map, int amplifier) {
        if (amplifier < 0 | (Boolean)InfectionConfig.infectSlowness.get() == false) {
            return;
        }
        AttributeInstance attribute = map.getInstance(Attributes.MOVEMENT_SPEED);
        if (attribute == null) {
            return;
        }
        attribute.removeModifier(this.SPEED_MOD_NAME);
        attribute.addPermanentModifier(new AttributeModifier(this.SPEED_MOD_NAME, -0.1 * (double)amplifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    public void removeAttributeModifiers(AttributeMap map) {
        AttributeInstance attribute = map.getInstance(Attributes.MOVEMENT_SPEED);
        if (attribute != null) {
            attribute.removeModifier(this.SPEED_MOD_NAME);
        }
    }

    public static void apply(LivingEntity entity) {
        boolean prevented = InfectedEffect.preventInfection(entity);
        if (entity instanceof ServerPlayer) {
            InfectionPacketHandler.sendTo((CustomPacketPayload)new InfectMessage(prevented), (ServerPlayer)entity);
        }
        if (!prevented) {
            entity.addEffect(new MobEffectInstance(HordesInfection.INFECTED, InfectedEffect.getInfectionTime(entity)));
        }
    }

    public static boolean preventInfection(LivingEntity entity) {
        return entity.hasEffect(HordesInfection.IMMUNITY);
    }

    public static int getInfectionTime(LivingEntity entity) {
        int time = (Integer)InfectionConfig.ticksForEffectStage.get();
        Infection infection = (Infection)entity.getCapability(HordesCapabilities.INFECTION);
        if (infection != null) {
            time = (int)((double)time * Math.pow((Double)InfectionConfig.effectStageTickReduction.get(), infection.getInfectionCount()));
        }
        return time;
    }
}

