/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.values;

import com.google.gson.JsonObject;
import net.minecraft.core.Direction;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.values.ValueGetter;

public class EntityPosGetter<T extends Comparable<T>, Number>
implements ValueGetter<T> {
    private final ValueGetter<String> value;
    private final DataType<T> type;

    private EntityPosGetter(ValueGetter<String> value, DataType<T> type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public T get(HordePlayerEvent event) {
        if (!this.type.isNumber()) {
            return null;
        }
        Direction.Axis axis = Direction.Axis.byName((String)this.value.get(event));
        if (this.type == DataType.INT || this.type == DataType.LONG) {
            return (T)this.type.cast((Comparable)Integer.valueOf(event.getEntity().blockPosition().get(axis)));
        }
        return (T)this.type.cast((Comparable)Double.valueOf(event.getEntity().position().get(axis)));
    }

    public static <T extends Comparable<T>> ValueGetter deserialize(JsonObject object, DataType<T> type) {
        try {
            if (object.has("value")) {
                return new EntityPosGetter(ValueGetter.readValue(DataType.STRING, object.get("value")), type);
            }
        }
        catch (Exception e) {
            HordesLogger.logError("invalid value for hordes:entity_pos", e);
        }
        return null;
    }
}

