/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;

public class CommandResetHordeEvent {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(commandSource -> commandSource.hasPermission(1))).executes(CommandResetHordeEvent::execute)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(ctx -> CommandResetHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"player")))));
    }

    public static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.getEntity() instanceof Player) {
            return CommandResetHordeEvent.execute(ctx, Lists.newArrayList((Object[])new ServerPlayer[]{source.getPlayerOrException()}));
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        boolean succeeded = false;
        for (ServerPlayer player : players) {
            HordeEvent horde = HordeSavedData.getData(source.getLevel()).getEvent(player);
            if (horde == null) continue;
            horde.reset(player);
            source.getEntity().sendSystemMessage((Component)Component.translatable((String)"commands.hordes.HordeReset.success", (Object[])new Object[]{player.getName()}));
            succeeded = true;
        }
        return succeeded ? 1 : 0;
    }
}

