/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.client;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.smileycorp.hordes.config.ClientConfigHandler;

public class HordeClientHandler {
    public static final HordeClientHandler INSTANCE = new HordeClientHandler();
    private int day_length;
    private boolean horde_day;

    @SubscribeEvent
    public void fogColour(ViewportEvent.ComputeFogColor event) {
        if (!((Boolean)ClientConfigHandler.hordeEventTintsSky.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (this.isHordeNight((Level)level)) {
            float d = level.getSkyDarken((float)event.getPartialTick()) * 1.4f;
            Color rgb = ClientConfigHandler.getHordeSkyColour();
            event.setRed((1.0f - d) * (float)rgb.getRed() / 255.0f + d * event.getRed());
            event.setGreen((1.0f - d) * (float)rgb.getGreen() / 255.0f + d * event.getGreen());
            event.setBlue((1.0f - d) * (float)rgb.getBlue() / 255.0f + d * event.getBlue());
        }
    }

    public void playHordeSound(float dirX, float dirZ, ResourceLocation sound) {
        if (!((Boolean)ClientConfigHandler.hordeSpawnSound.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        level.playSound((Player)mc.player, BlockPos.containing((double)(mc.player.getX() + (double)(10.0f * dirX)), (double)mc.player.getY(), (double)(mc.player.getZ() + (double)(10.0f * dirZ))), SoundEvent.createVariableRangeEvent((ResourceLocation)sound), SoundSource.HOSTILE, 0.5f, 1.0f + (float)(level.random.nextInt(6) - 3) / 10.0f);
    }

    public void displayMessage(String text) {
        Minecraft mc = Minecraft.getInstance();
        Gui gui = mc.gui;
        MutableComponent message = Component.translatable((String)text);
        message.setStyle(Style.EMPTY.withColor(ClientConfigHandler.getHordeMessageColour()));
        if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 1) {
            gui.getChat().addMessage((Component)message);
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 2) {
            gui.overlayMessageString = message;
            gui.overlayMessageTime = (Integer)ClientConfigHandler.eventNotifyDuration.get();
            gui.animateOverlayMessageColor = false;
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 3) {
            gui.setTimes(5, ((Integer)ClientConfigHandler.eventNotifyDuration.get()).intValue(), 5);
            gui.setSubtitle((Component)message);
        }
    }

    public void setHordeDay(boolean horde_day, int day_length) {
        if (day_length > 0) {
            this.day_length = day_length;
        }
        this.horde_day = horde_day;
    }

    public boolean isHordeNight(Level level) {
        if (this.day_length == 0 | !this.horde_day) {
            return false;
        }
        return (double)(level.getDayTime() % (long)this.day_length) >= 0.5 * (double)this.day_length;
    }
}

