/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.HordeSpawnData;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;

public class HordePlayerEvent
extends Event {
    protected final Level level;
    protected final HordeEvent horde;
    protected final int day;
    private final ServerPlayer player;

    public HordePlayerEvent(ServerPlayer player, HordeEvent horde) {
        this.level = player.level();
        this.horde = horde;
        this.day = (int)Math.floor(this.level.getDayTime() / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        this.player = player;
    }

    public Level getLevel() {
        return this.level;
    }

    public HordeEvent getHorde() {
        return this.horde;
    }

    public int getDay() {
        return this.day;
    }

    public RandomSource getRandom() {
        return this.horde.getRandom();
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public LivingEntity getEntity() {
        return this.player;
    }

    public HordeSpawnData getSpawnData() {
        return this.horde.getSpawnData();
    }
}

