/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.capability.ZombifyPlayer;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.common.event.SpawnZombiePlayerEvent;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.config.ZombiePlayersConfig;
import net.smileycorp.hordes.infection.HordesInfection;

public class MiscEventHandler {
    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (HordesLogger.hasErrors()) {
            event.getEntity().sendSystemMessage((Component)Component.translatable((String)"message.hordes.DataError", (Object[])new Object[]{HordesLogger.getFiletext()}));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) || entity instanceof FakePlayer || entity.level().isClientSide || entity.level().getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        if (entity.hasEffect(HordesInfection.INFECTED) && ((Boolean)InfectionConfig.infectionSpawnsZombiePlayers.get()).booleanValue() && ((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue() || ((Boolean)ZombiePlayersConfig.zombieGraves.get()).booleanValue()) {
            ZombifyPlayer cap = (ZombifyPlayer)entity.getCapability(HordesCapabilities.ZOMBIFY_PLAYER, null);
            if (cap == null) {
                return;
            }
            cap.createZombie();
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onDrop(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getEntity() instanceof FakePlayer || event.getEntity().level().isClientSide || event.getEntity().level().getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.hasEffect(HordesInfection.INFECTED) && ((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue() || ((Boolean)ZombiePlayersConfig.zombieGraves.get()).booleanValue()) {
            ZombifyPlayer cap = (ZombifyPlayer)player.getCapability(HordesCapabilities.ZOMBIFY_PLAYER, null);
            if (cap == null) {
                return;
            }
            PlayerZombie zombie = cap.getZombie();
            if (zombie == null) {
                return;
            }
            if (((Boolean)ZombiePlayersConfig.zombiePlayersStoreItems.get()).booleanValue()) {
                Collection drops = event.getDrops();
                zombie.storeDrops(drops);
                drops.clear();
                event.setCanceled(true);
            }
            zombie.asEntity().setPersistenceRequired();
            player.level().addFreshEntity(zombie.asEntity());
            cap.clearZombie();
            player.removeEffect(HordesInfection.INFECTED);
        }
    }

    @SubscribeEvent
    public void entityConvert(LivingConversionEvent.Post event) {
        LivingEntity before = event.getEntity();
        if (before.level().isClientSide) {
            return;
        }
        LivingEntity after = event.getOutcome();
        if (before instanceof AbstractHorse && after instanceof AbstractHorse) {
            Container beforeInv = ((AbstractHorse)before).getInventory();
            Container afterInv = ((AbstractHorse)after).getInventory();
            for (int i = 0; i < Math.min(beforeInv.getContainerSize(), afterInv.getContainerSize()); ++i) {
                afterInv.setItem(i, beforeInv.getItem(i).copy());
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void spawnZombiePlayer(SpawnZombiePlayerEvent event) {
        Player player = event.getEntity();
        if (player.isUnderWater() && ((Boolean)ZombiePlayersConfig.drownedPlayers.get()).booleanValue()) {
            event.setEntityType((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.DROWNED_PLAYER.get()));
            return;
        }
        if (player.level().getBiome(player.blockPosition()).is(HordesEntities.HUSK_PLAYER_SPAWN_BIOMES) && ((Boolean)ZombiePlayersConfig.huskPlayers.get()).booleanValue()) {
            event.setEntityType((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.HUSK_PLAYER.get()));
        }
    }
}

