/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.smileycorp.hordes.common.entities.PlayerZombie;

public class ZombiePlayerModel<T extends Zombie>
extends PlayerModel<T> {
    protected boolean fixedArms = false;
    protected final Color colour;
    protected final boolean isDrowned;

    public ZombiePlayerModel(ModelPart part) {
        this(part, Color.WHITE, false);
    }

    public ZombiePlayerModel(ModelPart part, Color colour, boolean isDrowned) {
        super(part, false);
        this.colour = colour;
        this.isDrowned = isDrowned;
    }

    public void prepareMobModel(T entity, float f1, float f2, float f3) {
        if (!this.fixedArms) {
            Optional<UUID> optional = ((PlayerZombie)entity).getPlayerUUID();
            if (optional.isPresent() && DefaultPlayerSkin.get((UUID)optional.get()).equals((Object)"slim")) {
                this.slim = true;
            }
            this.fixedArms = true;
        }
        if (this.isDrowned) {
            this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
            this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
            ItemStack itemstack = entity.getItemInHand(InteractionHand.MAIN_HAND);
            if (itemstack.is(Items.TRIDENT) && entity.isAggressive()) {
                if (entity.getMainArm() == HumanoidArm.RIGHT) {
                    this.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                } else {
                    this.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                }
            }
        }
        super.prepareMobModel(entity, f1, f2, f3);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, age, headYaw, headPitch);
        AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)entity.isAggressive(), (float)this.attackTime, (float)age);
        if (this.isDrowned) {
            if (this.leftArmPose == HumanoidModel.ArmPose.THROW_SPEAR) {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
            }
            if (this.rightArmPose == HumanoidModel.ArmPose.THROW_SPEAR) {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
            }
            if (this.swimAmount > 0.0f) {
                this.rightArm.xRot = this.rotlerpRad(this.swimAmount, this.rightArm.xRot, -2.5132742f) + this.swimAmount * 0.35f * Mth.sin((float)(0.1f * age));
                this.leftArm.xRot = this.rotlerpRad(this.swimAmount, this.leftArm.xRot, -2.5132742f) - this.swimAmount * 0.35f * Mth.sin((float)(0.1f * age));
                this.rightArm.zRot = this.rotlerpRad(this.swimAmount, this.rightArm.zRot, -0.15f);
                this.leftArm.zRot = this.rotlerpRad(this.swimAmount, this.leftArm.zRot, 0.15f);
                this.leftLeg.xRot -= this.swimAmount * 0.55f * Mth.sin((float)(0.1f * age));
                this.rightLeg.xRot += this.swimAmount * 0.55f * Mth.sin((float)(0.1f * age));
                this.head.xRot = 0.0f;
            }
        }
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int c) {
        super.renderToBuffer(poseStack, consumer, packedLight, packedOverlay, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)((float)this.colour.getRed() / 255.0f), (float)((float)this.colour.getGreen() / 255.0f), (float)((float)this.colour.getBlue() / 255.0f)));
    }
}

