/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.smileycorp.atlas.api.client.PlayerTextureRenderer;
import net.smileycorp.hordes.client.render.ZombiePlayerModel;
import net.smileycorp.hordes.client.render.ZombiePlayerRenderer;
import net.smileycorp.hordes.common.entities.PlayerZombie;

public class ZombiePlayerCapeLayer<T extends Zombie>
extends RenderLayer<T, ZombiePlayerModel<T>> {
    public ZombiePlayerCapeLayer(ZombiePlayerRenderer<T> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float pt, float age, float headYaw, float headPitch) {
        if (!((PlayerZombie)entity).displayCape()) {
            return;
        }
        ItemStack itemstack = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (itemstack.getItem() == Items.ELYTRA) {
            return;
        }
        ResourceLocation loc = PlayerTextureRenderer.getTexture(((PlayerZombie)entity).getPlayerUUID(), (MinecraftProfileTexture.Type)MinecraftProfileTexture.Type.CAPE);
        if (loc == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.125);
        double d0 = Mth.lerp((double)pt, (double)((PlayerZombie)entity).getXCloakO(), (double)((PlayerZombie)entity).getXCloak()) - Mth.lerp((double)pt, (double)((Zombie)entity).xo, (double)entity.getX());
        double d2 = Mth.lerp((double)pt, (double)((PlayerZombie)entity).getZCloakO(), (double)((PlayerZombie)entity).getZCloak()) - Mth.lerp((double)pt, (double)((Zombie)entity).zo, (double)entity.getZ());
        float f = ((Zombie)entity).yBodyRotO + (((Zombie)entity).yBodyRot - ((Zombie)entity).yBodyRotO);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f1 = Mth.clamp((float)((float)(Mth.lerp((double)pt, (double)((PlayerZombie)entity).getYCloakO(), (double)((PlayerZombie)entity).getYCloak()) - Mth.lerp((double)pt, (double)((Zombie)entity).yo, (double)entity.getY())) * 10.0f), (float)-6.0f, (float)32.0f) + Mth.sin((float)(Mth.lerp((float)pt, (float)((Zombie)entity).walkDistO, (float)((Zombie)entity).walkDist) * 6.0f)) * 32.0f * pt;
        float f3 = Mth.clamp((float)((float)(d0 * d4 - d2 * d3) * 100.0f), (float)-20.0f, (float)20.0f);
        if (entity.isCrouching()) {
            f1 += 25.0f;
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + Mth.clamp((float)((float)(d0 * d3 + d2 * d4) * 100.0f), (float)0.0f, (float)150.0f) / 2.0f + f1));
        poseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
        VertexConsumer consumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)loc));
        ((ZombiePlayerModel)this.getParentModel()).renderCloak(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

