/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;
import ovh.corail.tombstone.effect.BaitEffect;
import ovh.corail.tombstone.effect.DecrepitudeEffect;
import ovh.corail.tombstone.effect.EarthlyGardenEffect;
import ovh.corail.tombstone.effect.FeatherFallEffect;
import ovh.corail.tombstone.effect.FrostResistanceEffect;
import ovh.corail.tombstone.effect.FrostbiteEffect;
import ovh.corail.tombstone.effect.GhostlyShapeEffect;
import ovh.corail.tombstone.effect.GiantStrengthEffect;
import ovh.corail.tombstone.effect.LittleWorldEffect;
import ovh.corail.tombstone.effect.MercyEffect;
import ovh.corail.tombstone.effect.PrayerEffect;
import ovh.corail.tombstone.effect.PurificationEffect;
import ovh.corail.tombstone.effect.RestorationEffect;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.effect.WeaverWalkEffect;
import ovh.corail.tombstone.helper.Helper;

public final class ModEffects {
    public static Holder<MobEffect> ghostly_shape = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> preservation = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> unstable_intangibility = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> diversion = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> feather_fall = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> purification = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> true_sight = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> reach = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> lightning_resistance = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> frost_resistance = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> bone_shield = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> bait = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> aquatic_life = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> frostbite = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> prayer = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> earthly_garden = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> discretion = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> mercy = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> restoration = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> weaver_walk = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> giant_strength = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> little_world = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> incurable = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> decrepitude = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> projectile_reflection = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> beyond_the_grave_bond = (Holder)Helper.unsafeNullCast();
    public static Holder<MobEffect> remanence = (Holder)Helper.unsafeNullCast();

    static void onRegister() {
        ghostly_shape = ModEffects.register(new GhostlyShapeEffect(), "ghostly_shape");
        preservation = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -6710785), "preservation");
        unstable_intangibility = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -3682061), "unstable_intangibility");
        diversion = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -4022785), "diversion");
        feather_fall = ModEffects.register(new FeatherFallEffect(), "feather_fall");
        purification = ModEffects.register(new PurificationEffect(), "purification");
        true_sight = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -396072), "true_sight");
        reach = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -16777216).noAttributeScale().addAttributeModifier(Attributes.BLOCK_INTERACTION_RANGE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"reach_block_range"), 1.5, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.ENTITY_INTERACTION_RANGE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"reach_entity_range"), 1.5, AttributeModifier.Operation.ADD_VALUE), "reach");
        lightning_resistance = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -13224294), "lightning_resistance");
        frost_resistance = ModEffects.register(new FrostResistanceEffect(), "frost_resistance");
        bone_shield = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -13223894).requireSync(), "bone_shield");
        bait = ModEffects.register(new BaitEffect(), "bait");
        aquatic_life = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -16599809).noAttributeScale().addAttributeModifier(NeoForgeMod.SWIM_SPEED, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"aquatic_life_swim_speed"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(Attributes.OXYGEN_BONUS, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"aquatic_life_oxygen_bonus"), 5.0, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.WATER_MOVEMENT_EFFICIENCY, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"aquatic_life_water_movement_efficiency"), 0.5, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.SUBMERGED_MINING_SPEED, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"aquatic_life_submerged_mining_speed"), 10.0, AttributeModifier.Operation.ADD_VALUE), "aquatic_life");
        frostbite = ModEffects.register(new FrostbiteEffect(), "frostbite");
        prayer = ModEffects.register(new PrayerEffect(), "prayer");
        earthly_garden = ModEffects.register(new EarthlyGardenEffect(), "earthly_garden");
        discretion = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -13228190), "discretion");
        mercy = ModEffects.register(new MercyEffect(), "mercy");
        restoration = ModEffects.register(new RestorationEffect(), "restoration");
        weaver_walk = ModEffects.register(new WeaverWalkEffect(), "weaver_walk");
        giant_strength = ModEffects.register(new GiantStrengthEffect(), "giant_strength");
        little_world = ModEffects.register(new LittleWorldEffect(), "little_world");
        incurable = ModEffects.register(new TombstoneEffect(MobEffectCategory.HARMFUL, -3397849), "incurable");
        decrepitude = ModEffects.register(new DecrepitudeEffect(), "decrepitude");
        projectile_reflection = ModEffects.register(new TombstoneEffect(MobEffectCategory.BENEFICIAL, -1516153), "projectile_reflection");
        beyond_the_grave_bond = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -10713089), "beyond_the_grave_bond");
        remanence = ModEffects.register(new TombstoneEffect(MobEffectCategory.NEUTRAL, -1632), "remanence");
    }

    private static Holder<MobEffect> register(MobEffect effect, String name) {
        return Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), (Object)effect);
    }
}

