/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import ovh.corail.tombstone.mixin.accessor.ShapedRecipeAccessor;
import ovh.corail.tombstone.recipe.DisableableShapedRecipe;

public class ShapedSerializer<T extends DisableableShapedRecipe>
implements RecipeSerializer<T> {
    private final DisableableShapedRecipe.Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public ShapedSerializer(DisableableShapedRecipe.Factory<T> factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> ((ShapedRecipeAccessor)((Object)recipe)).getPattern()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> ((ShapedRecipeAccessor)((Object)recipe)).getResult()), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification)).apply((Applicative)c, factory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf p_335571_) {
        String s = p_335571_.readUtf();
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_335571_.readEnum(CraftingBookCategory.class);
        ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)p_335571_);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_335571_);
        boolean showNotification = p_335571_.readBoolean();
        return this.factory.create(s, craftingbookcategory, shapedrecipepattern, itemstack, showNotification);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)((ShapedRecipeAccessor)recipe).getPattern());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((ShapedRecipeAccessor)recipe).getResult());
        buffer.writeBoolean(recipe.showNotification());
    }
}

