/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.perk.Perk;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.MOD)
public class PerkRegistry {
    public static final ResourceKey<Registry<Perk>> PERK_RESOURCE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"perks"));
    private static Registry<Perk> perkRegistry = (Registry)Helper.unsafeNullCast();

    @SubscribeEvent
    public static void createRegistry(NewRegistryEvent event) {
        perkRegistry = event.create(new RegistryBuilder(PERK_RESOURCE_KEY).defaultKey(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"jailer")).maxId(512));
    }

    @Nullable
    public static Perk getValue(ResourceLocation id) {
        return (Perk)perkRegistry.get(id);
    }

    @Nullable
    public static Perk getValue(String id) {
        return PerkRegistry.getValue(ResourceLocation.parse((String)id));
    }

    @Nullable
    public static ResourceLocation getKey(@Nullable Perk perk) {
        return Optional.ofNullable(perk).map(arg_0 -> perkRegistry.getKey(arg_0)).orElse(null);
    }

    public static String getStringKey(@Nullable Perk perk) {
        return Optional.ofNullable(PerkRegistry.getKey(perk)).map(ResourceLocation::toString).orElse("");
    }

    public static Stream<Perk> values() {
        return perkRegistry.stream();
    }
}

