/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModTags;

public class RandomScrollBuffFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"random_scroll_buff");
    public static final MapCodec<RandomScrollBuffFunction> CODEC = RecordCodecBuilder.mapCodec(b -> RandomScrollBuffFunction.commonFields((RecordCodecBuilder.Instance)b).and((App)Codec.BOOL.fieldOf("ancient").orElse((Object)false).forGetter(g -> g.isAncient)).apply((Applicative)b, RandomScrollBuffFunction::new));
    private final boolean isAncient;

    protected RandomScrollBuffFunction(List<LootItemCondition> conditionsIn, boolean isAncient) {
        super(conditionsIn);
        this.isAncient = isAncient;
    }

    public LootItemFunctionType<RandomScrollBuffFunction> getType() {
        return ModLootFunctions.RANDOM_SCROLL_BUFF;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        RandomWeightedItem generator = LootHelper.getItemGenerator(ModTags.Items.magic_scrolls);
        ItemStack result = Optional.ofNullable(generator.getRandomItem()).filter(i -> {
            IDisableable disableable;
            return !(i instanceof IDisableable) || (disableable = (IDisableable)i).isEnabled();
        }).map(ItemStack::new).orElse(ItemStack.EMPTY);
        if (!result.isEmpty()) {
            result.set(ModDataComponents.ENCHANTED, (Object)true);
            if (this.isAncient) {
                result.set(ModDataComponents.ANCIENT, (Object)true);
            }
        }
        return result;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean isAncient;

        public Builder(boolean isAncient) {
            this.isAncient = isAncient;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new RandomScrollBuffFunction(this.getConditions(), this.isAncient);
        }
    }
}

